/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.MobileConfigDao;
import nxd.dao.ParamTest;
import nxd.data.MobileConfigData;
import nxd.data.UserData;
import nxd.data.UserIpData;
import nxd.l.l;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.e;
import nxd.lib.f;
import nxd.p;
import org.apache.commons.codec.digest.DigestUtils;

public class UserDao
extends FirstDao {
    private Map<Integer, String> a = null;
    private Map<Integer, String> b = null;
    private int e = 0;

    public UserDao() {
    }

    public UserDao(int n2) {
        this.e = n2;
    }

    private boolean a(int n2) {
        b b2 = DaoUtil.getDbConfig();
        int n3 = b2.f("select count(*) from user where id = ? and system_flag = 'TRUE'", new Object[]{n2});
        b2.close();
        return n3 > 0;
    }

    private List<UserIpData> b(int n2) {
        ArrayList<UserIpData> arrayList = new ArrayList<UserIpData>();
        b b2 = DaoUtil.getDbConfig();
        String string = "select * from user_ip where user_id = ? order by id";
        RowSet rowSet = b2.l(string, new Object[]{n2});
        while (rowSet.next()) {
            UserIpData userIpData = new UserIpData();
            userIpData.id = rowSet.getInt("id");
            userIpData.userId = rowSet.getInt("user_id");
            userIpData.startIp = rowSet.getString("start_ip");
            userIpData.endIp = rowSet.getString("end_ip");
            arrayList.add(userIpData);
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    private String a() {
        String string;
        String string2 = "op_id >= 0";
        if (this.e > 0) {
            string2 = "op_id = " + this.e;
        }
        if (nxd.lib.c.a(string = this.searchOption.toSql(12))) {
            return " where " + string2;
        }
        return String.format(" where %s and (%s)", string2, string);
    }

    public int selectCount() {
        String string = this.a();
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from user" + string);
        b2.close();
        return n2;
    }

    private UserData a(RowSet rowSet) {
        if (this.a == null) {
            this.a = DaoUtil.getPolicyIdNameMap();
        }
        if (this.b == null) {
            this.b = DaoUtil.getOpIdNameMap();
        }
        UserData userData = new UserData();
        userData.id = rowSet.getInt("id");
        userData.name = rowSet.getString("name");
        userData.passwd = rowSet.getString("passwd");
        userData.description = rowSet.getString("description");
        userData.token = rowSet.getString("token");
        userData.expDate = rowSet.getString("exp_date");
        userData.policyId = rowSet.getInt("policy_id");
        userData.ftPolicyId = rowSet.getInt("ft_policy_id");
        userData.policyName = nxd.lib.c.a((Object)this.a.get(userData.policyId));
        userData.ftPolicyName = nxd.lib.c.a((Object)this.a.get(userData.ftPolicyId));
        userData.ipList = this.b(userData.id);
        userData.opId = rowSet.getInt("op_id");
        userData.opName = nxd.lib.c.a((Object)this.b.get(userData.opId));
        userData.systemFlag = rowSet.str2bool("system_flag");
        return userData;
    }

    public List<UserData> selectList() {
        String string = this.a();
        int n2 = nxd.lib.c.a(this.limit, this.page);
        ArrayList<UserData> arrayList = new ArrayList<UserData>();
        String string2 = "select * from user" + string;
        string2 = string2 + " order by system_flag desc, lower(name)";
        if (this.limit > 0) {
            string2 = string2 + String.format(" limit %s, %s", n2, this.limit);
        }
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.l(string2);
        while (rowSet.next()) {
            arrayList.add(this.a(rowSet));
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    public List<UserData> selectListAll() {
        ArrayList<UserData> arrayList = new ArrayList<UserData>();
        String string = "select * from user";
        string = string + " order by op_id, lower(name)";
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.l(string);
        while (rowSet.next()) {
            arrayList.add(this.a(rowSet));
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    public boolean isValidOwner(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) from user where id = ? and op_id = ?";
        int n3 = b2.f(string, new Object[]{n2, this.e});
        b2.close();
        return n3 > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int n2) {
        if (!this.isValidOwner(n2)) {
            this.d.error("UDcP, Not a valid owner!");
            return false;
        }
        if (this.a(n2)) {
            this.d.error("UDcP, You can't delete your default user!");
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "delete from user_ip where user_id = ?";
            b2.c(string, new Object[]{n2});
            string = "delete from user where id = ?";
            b2.c(string, new Object[]{n2});
        }
        if (!DaoUtil.deleteOrphan()) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("user");
        return true;
    }

    private boolean a(UserData userData) {
        if (!DaoUtil.isOperatorId(this.e)) {
            this.d.error("UDcP, No operator found!");
            return false;
        }
        if (!nxd.lib.c.a(userData.passwd) && !nxd.lib.c.g(userData.passwd)) {
            if (!ParamTest.isValidPasswdLen(userData.passwd)) {
                this.d.error("UDcP, {}", (Object)ParamTest.ERR_PASSWD_LEN);
                return false;
            }
            if (!ParamTest.isValidPasswdChar(userData.passwd)) {
                this.d.error("UDcP, {}", (Object)"Only ASCII character allowed in password.");
                return false;
            }
        }
        if (!nxd.lib.c.a(userData.token)) {
            if (!ParamTest.isValidToken(userData.token)) {
                this.d.error("UDcP, {}", (Object)"Not a valid token, only alphabet and number, length must be 8.");
                return false;
            }
            if (ParamTest.isDupToken(userData.id, userData.token)) {
                this.d.error("UDcP, Token already exist!");
                return false;
            }
        }
        return true;
    }

    private boolean b(UserData userData) {
        this.a(userData);
        if (!ParamTest.isValidNameLen(userData.name)) {
            this.d.error("UDcPI, {}", (Object)ParamTest.ERR_NAME_LEN);
            return false;
        }
        if (!ParamTest.isValidUsernameChar(userData.name)) {
            this.d.error("UDcPI, {}", (Object)"Only alphabet, number, [.@-_] allowed in username.");
            return false;
        }
        if (ParamTest.isDupUser(userData.name, this.e)) {
            this.d.error("UDcPI, User already exists!");
            return false;
        }
        return true;
    }

    private boolean c(UserData userData) {
        return this.a(userData);
    }

    public boolean insert(UserData userData) {
        userData.sanitize();
        if (!this.b(userData)) {
            return false;
        }
        if (DaoUtil.hasMaxUserForLicense()) {
            this.d.error("UDi, Too many users license violation!");
            return false;
        }
        if (ParamTest.hasMaxUserForOperator(this.e)) {
            this.d.error("UDi, Too many users for an operator!");
            return false;
        }
        if (!nxd.lib.c.a(userData.passwd) && !nxd.lib.c.g(userData.passwd)) {
            userData.passwd = DigestUtils.shaHex(userData.passwd);
        }
        userData.policyId = DaoUtil.getDefaultPolicyIdForOperator(this.e);
        b b2 = DaoUtil.getDbConfig();
        if (nxd.lib.c.a(userData.token)) {
            userData.token = l.a(b2, 8);
        }
        String string = "insert into user(name, passwd, description, policy_id, ft_policy_id, exp_date, token, system_flag, op_id)";
        boolean bl = b2.d(string = string + " values(?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{userData.name, userData.passwd, userData.description, userData.policyId, userData.policyId, userData.expDate, userData.token, nxd.lib.c.d(userData.systemFlag), this.e});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("user");
        return true;
    }

    private UserData a(String string, Object[] objectArray) {
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.m(string, objectArray);
        if (rowSet == null) {
            b2.close();
            return null;
        }
        UserData userData = this.a(rowSet);
        rowSet.close();
        b2.close();
        return userData;
    }

    public UserData selectOne(int n2) {
        String string = "select * from user where id = ?";
        return this.a(string, new Object[]{n2});
    }

    public UserData selectOneByName(String string) {
        String string2 = "select * from user where name = ?";
        return this.a(string2, new Object[]{string});
    }

    public boolean update(UserData userData) {
        userData.sanitize();
        if (!this.isValidOwner(userData.id)) {
            this.d.error("UDu, Not a valid owner!");
            return false;
        }
        if (!this.c(userData)) {
            return false;
        }
        if (!nxd.lib.c.a(userData.passwd) && !nxd.lib.c.g(userData.passwd)) {
            userData.passwd = DigestUtils.shaHex(userData.passwd);
        }
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "update user set passwd = ?, description = ?";
            string = string + ", policy_id = ?, ft_policy_id = ?, exp_date = ? where id = ?";
            b2.b(string, new Object[]{userData.passwd, userData.description, userData.policyId, userData.ftPolicyId, userData.expDate, userData.id});
        }
        catch (Exception exception) {
            this.d.error("DB error!");
            exception.printStackTrace();
        }
        this.c.b("user");
        return true;
    }

    public boolean newToken(int n2) {
        if (!this.isValidOwner(n2)) {
            this.d.error("UDnT, Not a valid owner!");
            return false;
        }
        UserData userData = this.selectOne(n2);
        b b2 = DaoUtil.getDbConfig();
        userData.token = l.a(b2, 8);
        b2.close();
        return this.update(userData);
    }

    private boolean a(UserIpData userIpData) {
        if (!f.b(userIpData.startIp) && !f.e(userIpData.startIp)) {
            this.d.error("UDcPIp, Invalid IP or domain!");
            return false;
        }
        if (!(!f.b(userIpData.endIp) || f.h(userIpData.startIp) && f.h(userIpData.endIp))) {
            this.d.error("UDcPIp, Only private IP range allowed!");
            return false;
        }
        if (f.b(userIpData.endIp) && f.k(userIpData.startIp) > f.k(userIpData.endIp)) {
            this.d.error("UDcPIp, Start IP = {} bigger than End IP = {}.", (Object)userIpData.startIp, (Object)userIpData.endIp);
            return false;
        }
        if (ParamTest.hasMaxUserIpForOperator(this.e)) {
            this.d.error("UDcPIp, Can't add more IP!");
            return false;
        }
        if (ParamTest.isDupUserIp(userIpData.startIp)) {
            String string = "";
            String string2 = "";
            try (b b2 = DaoUtil.getDbConfig();){
                string = b2.e("select name from operator where id = " + this.e);
                string2 = b2.e("select name from user where id = " + userIpData.userId);
            }
            this.d.error("UDcPIp, IP already exists! - Already taken by operator = {}, user = {}.", (Object)string, (Object)string2);
            return false;
        }
        return true;
    }

    public boolean addIp(UserIpData userIpData) {
        userIpData.sanitize();
        if (!this.isValidOwner(userIpData.userId)) {
            this.d.error("UDaI, Not a valid owner!");
            return false;
        }
        if (!this.a(userIpData)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "insert into user_ip(user_id, start_ip, end_ip, op_id) values(?, ?, ?, ?)";
        boolean bl = b2.d(string, new Object[]{userIpData.userId, userIpData.startIp, userIpData.endIp, this.e});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("user");
        return true;
    }

    public boolean deleteIp(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select user_id from user_ip where id = ?";
        int n3 = b2.f(string, new Object[]{n2});
        if (!this.isValidOwner(n3)) {
            this.d.error("UDdI, Not a valid owner!");
            b2.close();
            return false;
        }
        string = "delete from user_ip where id = ?";
        boolean bl = b2.d(string, new Object[]{n2});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("user");
        return true;
    }

    public String writeMobileConfigFile(int n2) {
        String string = "";
        UserData userData = this.selectOne(n2);
        MobileConfigData mobileConfigData = new MobileConfigDao().selectOne();
        String string2 = mobileConfigData.template;
        string2 = string2.replace("#{uname}", userData.name);
        string2 = string2.replace("#{token}", userData.token);
        for (int i2 = 1; i2 <= 4; ++i2) {
            string2 = string2.replace("#{uuid" + i2 + "}", UUID.randomUUID().toString().toUpperCase());
        }
        string = p.l + "/" + userData.name + ".mobileconfig";
        nxd.lib.e.c(string, string2, "UTF-8");
        return string;
    }
}

