/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import nxd.a.d;
import nxd.dao.AlertDao;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.LangDao;
import nxd.dao.LicensePolicyDao;
import nxd.dao.OperatorDao;
import nxd.dao.ParamTest;
import nxd.data.LicensePolicyData;
import nxd.data.OperatorData;
import nxd.data.SignupRequestData;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.f;
import org.apache.commons.codec.digest.DigestUtils;

public class SignupRequestDao
extends FirstDao {
    public void addKw(String string) {
        if (this.searchOption.size() > 0) {
            return;
        }
        this.searchOption.addKw("username", string, 2);
        this.searchOption.addKw("email", string, 2);
    }

    private String a() {
        String string = this.searchOption.toSql(12);
        if (nxd.lib.c.a(string)) {
            return "";
        }
        return " where " + string;
    }

    public int selectCount() {
        String string = this.a();
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from signup_request" + string);
        b2.close();
        return n2;
    }

    private SignupRequestData a(RowSet rowSet) {
        SignupRequestData signupRequestData = new SignupRequestData();
        signupRequestData.id = rowSet.getInt("id");
        signupRequestData.ctime = rowSet.getString("ctime");
        signupRequestData.username = rowSet.getString("username");
        signupRequestData.passwd = rowSet.getString("passwd");
        signupRequestData.email = rowSet.getString("email");
        signupRequestData.usr1 = rowSet.getString("usr1");
        signupRequestData.usr2 = rowSet.getString("usr2");
        signupRequestData.usr3 = rowSet.getString("usr3");
        signupRequestData.usr4 = rowSet.getString("usr4");
        signupRequestData.approvedFlag = rowSet.getBoolean("approved_flag");
        return signupRequestData;
    }

    public List<SignupRequestData> selectList() {
        String string = this.a();
        int n2 = nxd.lib.c.a(this.limit, this.page);
        ArrayList<SignupRequestData> arrayList = new ArrayList<SignupRequestData>();
        String string2 = "select * from signup_request" + string;
        string2 = string2 + " order by id desc";
        if (this.limit > 0) {
            string2 = string2 + String.format(" limit %s, %s", n2, this.limit);
        }
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.l(string2);
        while (rowSet.next()) {
            arrayList.add(this.a(rowSet));
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int n2) {
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "delete from signup_request where id = ?";
            b2.c(string, new Object[]{n2});
        }
        return true;
    }

    private boolean a(SignupRequestData signupRequestData) {
        if (!ParamTest.isValidNameLen(signupRequestData.username)) {
            this.d.error("SignupRequestDao.checkParam, {}", (Object)ParamTest.ERR_NAME_LEN);
            return false;
        }
        if (!ParamTest.isValidUsernameChar(signupRequestData.username)) {
            this.d.error("SignupRequestDao.checkParam, {}", (Object)"Only alphabet, number, [.@-_] allowed in username.");
            return false;
        }
        if (ParamTest.isDupSignupUsername(signupRequestData.username)) {
            this.d.error("SignupRequestDao.checkParam, Signup username already exists!");
            return false;
        }
        if (!nxd.lib.c.a(signupRequestData.passwd) && !nxd.lib.c.g(signupRequestData.passwd)) {
            if (!ParamTest.isValidPasswdLen(signupRequestData.passwd)) {
                this.d.error("SignupRequestDao.checkParam, {}", (Object)ParamTest.ERR_PASSWD_LEN);
                return false;
            }
            if (!ParamTest.isValidPasswdChar(signupRequestData.passwd)) {
                this.d.error("SignupRequestDao.checkParam, {}", (Object)"Only ASCII character allowed in password.");
                return false;
            }
        }
        if (nxd.lib.c.b(signupRequestData.email) && !f.g(signupRequestData.email)) {
            this.d.error("SignupRequestDao.checkParam, Invalid email!");
            return false;
        }
        return true;
    }

    public boolean insert(SignupRequestData signupRequestData) {
        SignupRequestData signupRequestData2;
        signupRequestData.sanitize();
        if (!this.a(signupRequestData)) {
            return false;
        }
        if (!nxd.lib.c.a(signupRequestData.passwd) && !nxd.lib.c.g(signupRequestData.passwd)) {
            signupRequestData.passwd = DigestUtils.shaHex(signupRequestData.passwd);
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "insert into signup_request(username, passwd, email, user_num, type, usr1, usr2, usr3, usr4)";
        boolean bl = b2.d(string = string + " values(?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{signupRequestData.username, signupRequestData.passwd, signupRequestData.email, signupRequestData.userNum, signupRequestData.type, signupRequestData.usr1, signupRequestData.usr2, signupRequestData.usr3, signupRequestData.usr4});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        String string2 = String.format("New signup request from %s.", signupRequestData.username);
        nxd.a.d.a().a(string2, signupRequestData.toEmailText(), "");
        LicensePolicyData licensePolicyData = new LicensePolicyDao().selectOne();
        if (licensePolicyData.onSignupRequest == 4 && !this.a(licensePolicyData, signupRequestData2 = this.selectOneByName(signupRequestData.username))) {
            string2 = String.format("Signup request approval for %s has been failed!", signupRequestData.username);
            nxd.a.d.a().a(string2, "It's failed!", "");
        }
        return true;
    }

    private SignupRequestData a(String string, Object[] objectArray) {
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.m(string, objectArray);
        if (rowSet == null) {
            b2.close();
            return null;
        }
        SignupRequestData signupRequestData = this.a(rowSet);
        rowSet.close();
        b2.close();
        return signupRequestData;
    }

    public SignupRequestData selectOne(int n2) {
        String string = "select * from signup_request where id = ?";
        return this.a(string, new Object[]{n2});
    }

    public SignupRequestData selectOneByName(String string) {
        String string2 = "select * from signup_request where username = ?";
        return this.a(string2, new Object[]{string});
    }

    private boolean a(LicensePolicyData licensePolicyData, SignupRequestData signupRequestData) {
        Object object;
        Object object2;
        OperatorData operatorData = new OperatorData();
        operatorData.name = signupRequestData.username;
        operatorData.passwd = signupRequestData.passwd;
        operatorData.email = signupRequestData.email;
        operatorData.maxUser = signupRequestData.userNum > 0 ? signupRequestData.userNum : licensePolicyData.maxUser;
        operatorData.type = signupRequestData.type > 0 ? signupRequestData.type : 1;
        operatorData.maxUserIp = licensePolicyData.maxUserIp;
        operatorData.maxPolicy = licensePolicyData.maxPolicy;
        operatorData.maxWhitelist = licensePolicyData.maxWhitelist;
        operatorData.maxFreeTime = licensePolicyData.maxFreeTime;
        if (!new OperatorDao().insert(operatorData)) {
            this.d.error("SignupRequestDao.approve, Couldn't create an operator! - {}.", (Object)operatorData.name);
            return false;
        }
        String string = "update signup_request set approved_flag = true where id = ?";
        try {
            object2 = DaoUtil.getDbConfig();
            object = null;
            try {
                ((b)object2).b(string, new Object[]{signupRequestData.id});
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((b)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((b)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.d.error("SignupRequestDao.approve, " + exception.toString());
            return false;
        }
        if (licensePolicyData.onSignupApproval == 1) {
            object2 = new LangDao();
            object = String.format(((LangDao)object2).translate("Signup request has been approved for %s."), signupRequestData.username);
            String string2 = ((LangDao)object2).translate("Your signup request has been approved.");
            AlertDao.sendSignupApprovalEmail((String)object, string2, signupRequestData.email);
        }
        return true;
    }

    public boolean approve(int n2) {
        SignupRequestData signupRequestData = this.selectOne(n2);
        if (signupRequestData == null) {
            this.d.error("SignupRequestDao.approve, No signup request by id = {}!", (Object)n2);
            return false;
        }
        LicensePolicyData licensePolicyData = new LicensePolicyDao().selectOne();
        return this.a(licensePolicyData, signupRequestData);
    }
}

