/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.OperatorDao;
import nxd.data.OperatorData;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.f;

public class ParamTest
extends FirstDao {
    public static final int MIN_NAME_LEN = 1;
    public static final int MAX_NAME_LEN = 64;
    public static final int MIN_PASSWD_LEN = 1;
    public static final int MAX_PASSWD_LEN = 128;
    public static final String ERR_NAME_CHAR = "Only alphabet, number, [-_] allowed in name.";
    public static final String ERR_USERNAME_CHAR = "Only alphabet, number, [.@-_] allowed in username.";
    public static final String ERR_PASSWD_CHAR = "Only ASCII character allowed in password.";
    public static final String ERR_TOKEN_INVALID = "Not a valid token, only alphabet and number, length must be 8.";
    public static String ERR_NAME_LEN = "Name length must be between %s and %s.";
    public static String ERR_PASSWD_LEN = "Password length must be between %s and %s.";
    public static final String ERR_CLASSIFICATION_RULE_INVALID = "Not a valid classfication rule.";

    public static boolean isValidNameLen(String string) {
        return string.length() >= 1 && string.length() <= 64;
    }

    public static boolean isValidNameChar(String string) {
        return !string.matches(".*[^a-zA-Z0-9_-].*");
    }

    public static boolean isValidUsernameChar(String string) {
        return !string.matches(".*[^a-zA-Z0-9\\.@_-].*");
    }

    public static boolean isValidPasswdLen(String string) {
        return string.length() >= 1 && string.length() <= 128;
    }

    public static boolean isValidPasswdChar(String string) {
        return nxd.lib.c.f(string);
    }

    public static boolean isDupWhitelistDomain(String string, int n2) {
        b b2 = DaoUtil.getDbConfig();
        int n3 = b2.f("select count(*) from whitelist where domain = ? and op_id = ?", new Object[]{string, n2});
        b2.close();
        return n3 > 0;
    }

    public static boolean isDupWhitelistKeyword(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from whitelist_kw where keyword = ?", new Object[]{string});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupCategoryCustom(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from category_custom where name = ?", new Object[]{string});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupPolicy(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from policy where lower(name) = ?", new Object[]{string.toLowerCase()});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupPolicy(String string, int n2) {
        b b2 = DaoUtil.getDbConfig();
        int n3 = b2.f("select count(*) from policy where lower(name) = ? and op_id = ?", new Object[]{string.toLowerCase(), n2});
        b2.close();
        return n3 > 0;
    }

    public static boolean isDupUser(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from user where lower(name) = ?", new Object[]{string.toLowerCase()});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupUser(String string, int n2) {
        b b2 = DaoUtil.getDbConfig();
        int n3 = b2.f("select count(*) from user where lower(name) = ? and op_id = ?", new Object[]{string.toLowerCase(), n2});
        b2.close();
        return n3 > 0;
    }

    public static boolean isDupToken(int n2, String string) {
        b b2 = DaoUtil.getDbConfig();
        int n3 = b2.f("select count(*) from user where id <> ? and token = ?", new Object[]{n2, string.toUpperCase()});
        b2.close();
        return n3 > 0;
    }

    public static boolean isDupUserIp(String string) {
        if (f.h(string)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from user_ip where start_ip = ?", new Object[]{string});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupSubAdmin(String string) {
        if (string.equals("admin")) {
            return true;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            int n2 = b2.f("select count(*) from sub_admin where lower(name) = ?", new Object[]{string.toLowerCase()});
            if (n2 > 0) {
                boolean bl = true;
                return bl;
            }
            n2 = b2.f("select count(*) from operator where lower(name) = ?", new Object[]{string.toLowerCase()});
            if (n2 > 0) {
                boolean bl = true;
                return bl;
            }
            String string2 = b2.e("select name from admin");
            if (string2.equals(string)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidToken(String string) {
        return string.matches(String.format("[a-zA-Z0-9]{%d}", 8));
    }

    public static boolean isValidBlockIp(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",|\\s+")) {
            if (f.b(string2 = string2.trim())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasMaxCustomDomain() {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) from category_domain";
        int n2 = b2.f(string);
        b2.close();
        return n2 >= 1000000;
    }

    public static boolean hasMaxCustomDomanyForCategory(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) from category_domain where category_id = " + n2;
        int n3 = b2.f(string);
        b2.close();
        return n3 >= 1000000;
    }

    public static boolean isDupCategoryDomain(String string, int n2) {
        b b2 = DaoUtil.getDbConfig();
        int n3 = b2.f("select count(*) from category_domain where domain = ? and category_id = ?", new Object[]{string, n2});
        b2.close();
        return n3 > 0;
    }

    public static boolean isDupOperator(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from operator where lower(name) = ?", new Object[]{string.toLowerCase()});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupSignupUsername(String string) {
        if (ParamTest.isDupOperator(string)) {
            return true;
        }
        if (ParamTest.isSameNameAsAdmin(string)) {
            return true;
        }
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from signup_request where lower(username) = ?", new Object[]{string.toLowerCase()});
        b2.close();
        return n2 > 0;
    }

    public static boolean isSameNameAsAdmin(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from admin where lower(name) = ?", new Object[]{string.toLowerCase()});
        b2.close();
        return n2 > 0;
    }

    public static boolean hasMaxUserForOperator(int n2) {
        OperatorData operatorData = new OperatorDao().selectOne(n2);
        if (operatorData == null) {
            return false;
        }
        return operatorData.userCnt >= operatorData.maxUser;
    }

    public static boolean hasMaxUserIpForOperator(int n2) {
        OperatorData operatorData = new OperatorDao().selectOne(n2);
        if (operatorData == null) {
            return false;
        }
        return operatorData.userIpCnt >= operatorData.maxUserIp;
    }

    public static boolean hasMaxPolicyForOperator(int n2) {
        OperatorData operatorData = new OperatorDao().selectOne(n2);
        if (operatorData == null) {
            return false;
        }
        return operatorData.policyCnt >= operatorData.maxPolicy;
    }

    public static boolean hasMaxWhitelistForOperator(int n2) {
        OperatorData operatorData = new OperatorDao().selectOne(n2);
        if (operatorData == null) {
            return false;
        }
        return operatorData.whitelistCnt >= operatorData.maxWhitelist;
    }

    public static boolean hasMaxFreeTimeForOperator(int n2) {
        OperatorData operatorData = new OperatorDao().selectOne(n2);
        if (operatorData == null) {
            return false;
        }
        return operatorData.freeTimeCnt >= operatorData.maxFreeTime;
    }

    public static boolean hasMaxUserForLicense() {
        return DaoUtil.hasMaxUserForLicense();
    }

    public static boolean testMaxLicenseUser(int n2) {
        return DaoUtil.checkMaxUserForLicense(n2);
    }

    public static boolean testMaxLicenseUser() {
        return DaoUtil.checkMaxUserForLicense(0);
    }

    public static boolean isValidIp(String string) {
        return f.b(string);
    }

    public static boolean isValidDomain(String string) {
        return f.e(string);
    }

    public static boolean isValidEmail(String string) {
        return f.g(string);
    }

    public static boolean isValidClassificationRule(String string) {
        if (string.contains("||") || string.contains("(|") || string.contains("|)")) {
            return false;
        }
        String string2 = string.replaceAll("\\\\.", "");
        if (string2.length() < 2) {
            return false;
        }
        try {
            Matcher matcher = Pattern.compile(string, 2).matcher("");
            return !matcher.find();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDupClassificationRule(String string, String string2, int n2) {
        int n3 = 0;
        try (b b2 = DaoUtil.getDbConfig();){
            n3 = b2.f("select count(*) from classifier_ruleset where target = ? and keyword = ? and category_id = ?", new Object[]{string, string2, n2});
        }
        return n3 > 0;
    }

    public static boolean isDupZoneFile(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from zone_file where domain = ?", new Object[]{string});
        b2.close();
        return n2 > 0;
    }

    public static boolean isValidRepositoryUrl(String string) {
        return string.matches("https?://.*/.+\\.(txt|tgz|tar\\.gz)");
    }

    public static boolean isValidBlocklistUrl(String string) {
        return string.matches("https?://.*");
    }

    public static String findInvalidAllowedIp(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("\\s+")) {
            String string3;
            String string4;
            String[] stringArray2;
            if ((string2 = string2.trim()).startsWith("px")) continue;
            if (string2.contains("/")) {
                try {
                    stringArray2 = new nxd.l.c(string2);
                    string4 = stringArray2.a();
                    string3 = stringArray2.b();
                    continue;
                }
                catch (Exception exception) {
                    return string2;
                }
            }
            if (string2.contains("-")) {
                stringArray2 = string2.split("-");
                if (stringArray2.length == 2) {
                    long l2;
                    string4 = stringArray2[0];
                    string3 = stringArray2[1];
                    long l3 = f.k(string4);
                    if (l3 > (l2 = f.k(string3))) {
                        return string2;
                    }
                    if (f.b(string4) && f.b(string3)) continue;
                }
                return string2;
            }
            if (f.b(string2)) continue;
            return string2;
        }
        return "";
    }

    public static boolean isValidUpstreamDnsServer(String string) {
        if (!string.contains(":")) {
            return f.b(string);
        }
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            return false;
        }
        if (!f.b(stringArray[0])) {
            return false;
        }
        int n2 = nxd.lib.c.d(stringArray[1]);
        return n2 > 0 && n2 <= 65535;
    }

    static {
        ERR_NAME_LEN = String.format(ERR_NAME_LEN, 1, 64);
        ERR_PASSWD_LEN = String.format(ERR_PASSWD_LEN, 1, 128);
    }
}

