/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import nxd.c;
import nxd.dao.CategoryCustomDao;
import nxd.dao.CategorySystemDao;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.FreeTimeDao;
import nxd.dao.ParamTest;
import nxd.dao.PolicyCxBlockDao;
import nxd.dao.PolicyDao;
import nxd.dao.PolicyNxProxyDao;
import nxd.dao.PolicyProxyDao;
import nxd.dao.SignupRequestDao;
import nxd.dao.UserDao;
import nxd.data.CategoryData;
import nxd.data.FreeTimeData;
import nxd.data.OperatorData;
import nxd.data.PolicyData;
import nxd.data.SignupRequestData;
import nxd.data.UserData;
import nxd.l.l;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.d;
import nxd.lib.f;
import org.apache.commons.codec.digest.DigestUtils;

public class OperatorDao
extends FirstDao {
    private int a = 0;

    public OperatorDao() {
    }

    public OperatorDao(int n2) {
        this.a = n2;
    }

    public void addKw(String string) {
        if (this.searchOption.size() > 0) {
            return;
        }
        this.searchOption.addKw("name", string, 2);
        this.searchOption.addKw("description", string, 2);
        this.searchOption.addKw("email", string, 2);
    }

    private String a() {
        String string = this.searchOption.toSql(12);
        if (nxd.lib.c.a(string)) {
            return "";
        }
        return " where " + string;
    }

    public int selectCount() {
        String string = this.a();
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from operator" + string);
        b2.close();
        return n2;
    }

    public int selectTrialCount() {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from operator where trial_flag = 'TRUE'");
        b2.close();
        return n2;
    }

    public int selectSuspendedCount() {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from operator where stop_flag = 'TRUE'");
        b2.close();
        return n2;
    }

    private OperatorData a(RowSet rowSet) {
        OperatorData operatorData = new OperatorData();
        operatorData.id = rowSet.getInt("id");
        operatorData.name = rowSet.getString("name");
        operatorData.passwd = rowSet.getString("passwd");
        operatorData.description = rowSet.getString("description");
        operatorData.email = rowSet.getString("email");
        operatorData.alertPeriod = rowSet.getInt("alert_period");
        operatorData.stopFlag = rowSet.str2bool("stop_flag");
        operatorData.maxUser = rowSet.getInt("max_user");
        operatorData.maxUserIp = rowSet.getInt("max_user_ip");
        operatorData.maxPolicy = rowSet.getInt("max_policy");
        operatorData.maxWhitelist = rowSet.getInt("max_whitelist");
        operatorData.maxFreeTime = rowSet.getInt("max_free_time");
        operatorData.type = rowSet.getInt("type");
        operatorData.userCnt = this.a(operatorData.id);
        operatorData.userIpCnt = this.b(operatorData.id);
        operatorData.policyCnt = this.c(operatorData.id);
        operatorData.whitelistCnt = this.d(operatorData.id);
        operatorData.freeTimeCnt = this.e(operatorData.id);
        operatorData.expDate = rowSet.getString("exp_date");
        operatorData.ctime = rowSet.getString("ctime");
        operatorData.trialFlag = rowSet.str2bool("trial_flag");
        operatorData.recvAlertAdminBlock = rowSet.str2bool("recv_alert_admin_block");
        operatorData.recvAlertCategoryBlock = rowSet.str2bool("recv_alert_category_block");
        operatorData.recvAlertUnclassified = rowSet.str2bool("recv_alert_unclassified");
        operatorData.recvAlertBlockTime = rowSet.str2bool("recv_alert_block_time");
        operatorData.recvAlertSystemBlock = rowSet.str2bool("recv_alert_system_block");
        operatorData.recvAlertOtherReasons = rowSet.str2bool("recv_alert_other_reasons");
        operatorData.alertCategory = rowSet.getString("alert_category");
        boolean bl = false;
        if (operatorData.alertCategory.equals("ALL")) {
            bl = true;
        }
        BitSet bitSet = nxd.lib.c.c(operatorData.alertCategory);
        operatorData.alertCategoryList = new CategorySystemDao().selectList();
        operatorData.alertCategoryList.addAll(new CategoryCustomDao().selectList());
        for (CategoryData categoryData : operatorData.alertCategoryList) {
            if (!bl && !bitSet.get(categoryData.id)) continue;
            categoryData.checkFlag = true;
        }
        return operatorData;
    }

    private OperatorData a(String string, Object[] objectArray) {
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.m(string, objectArray);
        if (rowSet == null) {
            b2.close();
            return null;
        }
        OperatorData operatorData = this.a(rowSet);
        rowSet.close();
        b2.close();
        return operatorData;
    }

    public OperatorData selectOne(int n2) {
        String string = "select * from operator where id = ?";
        return this.a(string, new Object[]{n2});
    }

    public OperatorData selectOneByName(String string) {
        String string2 = "select * from operator where name = ?";
        return this.a(string2, new Object[]{string});
    }

    private int a(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) cnt from user where op_id = ?";
        int n3 = b2.f(string, new Object[]{n2});
        b2.close();
        return n3;
    }

    private int b(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) cnt from user_ip where op_id = ?";
        int n3 = b2.f(string, new Object[]{n2});
        b2.close();
        return n3;
    }

    private int c(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) cnt from policy where op_id = ?";
        int n3 = b2.f(string, new Object[]{n2});
        b2.close();
        return n3;
    }

    private int d(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) cnt from whitelist where op_id = ?";
        int n3 = b2.f(string, new Object[]{n2});
        b2.close();
        return n3;
    }

    private int e(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) cnt from free_time where op_id = ?";
        int n3 = b2.f(string, new Object[]{n2});
        b2.close();
        return n3;
    }

    public OperatorData selectSum() {
        b b2 = DaoUtil.getDbConfig();
        OperatorData operatorData = new OperatorData();
        operatorData.userCnt = b2.f("select count(*) from user");
        operatorData.maxUser = b2.f("select sum(max_user) from operator");
        operatorData.maxUserActive = b2.f("select sum(max_user) from operator where stop_flag = 'FALSE'");
        operatorData.maxUserTrial = b2.f("select sum(max_user) from operator where trial_flag = 'TRUE'");
        operatorData.userIpCnt = b2.f("select count(*) from user_ip");
        operatorData.maxUserIp = b2.f("select sum(max_user_ip) from operator");
        operatorData.policyCnt = b2.f("select count(*) from policy where id > 1");
        operatorData.maxPolicy = b2.f("select sum(max_policy) from operator");
        operatorData.whitelistCnt = b2.f("select count(*) from whitelist where system_flag = 'FALSE'");
        operatorData.maxWhitelist = b2.f("select sum(max_whitelist) from operator");
        operatorData.freeTimeCnt = b2.f("select count(*) from free_time");
        operatorData.maxFreeTime = b2.f("select sum(max_free_time) from operator");
        b2.close();
        return operatorData;
    }

    public List<OperatorData> selectList() {
        String string = this.a();
        int n2 = nxd.lib.c.a(this.limit, this.page);
        ArrayList<OperatorData> arrayList = new ArrayList<OperatorData>();
        String string2 = "select * from operator" + string;
        string2 = string2 + String.format(" order by lower(name) limit %s, %s", n2, this.limit);
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.l(string2);
        while (rowSet.next()) {
            arrayList.add(this.a(rowSet));
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    private void a(String string) {
        try (b b2 = DaoUtil.getDbTraffic();){
            String string2 = nxd.c.f(string);
            String string3 = nxd.c.g(string);
            String string4 = "drop table if exists " + string2;
            b2.b(string4);
            string4 = "drop table if exists " + string3;
            b2.b(string4);
        }
        catch (Exception exception) {
            this.d.error("OperatorDao.deleteOpTrafficTables, DB error!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int n2) {
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "delete from user where op_id = ?";
            b2.b(string, new Object[]{n2});
            string = "delete from user_ip where op_id = ?";
            b2.b(string, new Object[]{n2});
            string = "delete from policy where op_id = ?";
            b2.b(string, new Object[]{n2});
            string = "delete from whitelist where op_id = ?";
            b2.b(string, new Object[]{n2});
            string = "delete from free_time where op_id = ?";
            b2.b(string, new Object[]{n2});
            string = "delete from policy_application where op_id = ?";
            b2.b(string, new Object[]{n2});
            string = "delete from policy_proxy where op_id = ?";
            b2.b(string, new Object[]{n2});
            string = "select name from operator where id = ?";
            String string2 = b2.e(string, new Object[]{n2});
            this.a(string2);
            string = "delete from operator where id = ?";
            b2.b(string, new Object[]{n2});
        }
        if (!DaoUtil.deleteOrphan()) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("operator");
        this.c.b("user");
        return true;
    }

    private boolean a(OperatorData operatorData) {
        if (!nxd.lib.c.a(operatorData.passwd) && !nxd.lib.c.g(operatorData.passwd)) {
            if (!ParamTest.isValidPasswdLen(operatorData.passwd)) {
                this.d.error("ODcP, {}", (Object)ParamTest.ERR_PASSWD_LEN);
                return false;
            }
            if (!ParamTest.isValidPasswdChar(operatorData.passwd)) {
                this.d.error("ODcP, {}", (Object)"Only ASCII character allowed in password.");
                return false;
            }
        }
        if (operatorData.alertPeriod > 0 && !f.g(operatorData.email)) {
            this.d.error("ODcP, Not a valid email!");
            return false;
        }
        return true;
    }

    private boolean b(OperatorData operatorData) {
        this.a(operatorData);
        if (DaoUtil.checkMaxUserForLicense(operatorData.maxUser)) {
            this.d.error("ODcPI, Too many users license violation!");
            return false;
        }
        if (!ParamTest.isValidNameLen(operatorData.name)) {
            this.d.error("ODcPI, {}", (Object)ParamTest.ERR_NAME_LEN);
            return false;
        }
        if (!ParamTest.isValidUsernameChar(operatorData.name)) {
            this.d.error("ODcPI, {}", (Object)"Only alphabet, number, [.@-_] allowed in username.");
            return false;
        }
        if (ParamTest.isDupOperator(operatorData.name)) {
            this.d.error("ODcPI, Operator alerady exists!");
            return false;
        }
        if (ParamTest.isSameNameAsAdmin(operatorData.name)) {
            this.d.error("ODcPI, Operator name can't be same as admin!");
            return false;
        }
        return true;
    }

    public boolean isOpTrialLicenseExpired(int n2) {
        return DaoUtil.isOpTrialLicenseExpired(n2);
    }

    private boolean c(OperatorData operatorData) {
        OperatorData operatorData2 = this.selectOne(operatorData.id);
        if (operatorData.trialFlag && this.isOpTrialLicenseExpired(operatorData.id)) {
            this.d.error("ODcPU, Trial license has already expired!");
            return false;
        }
        if (operatorData.maxUser < operatorData2.userCnt) {
            this.d.error("ODcPU, Max user already reached!");
            return false;
        }
        if (operatorData.maxUserIp < operatorData2.userIpCnt) {
            this.d.error("ODcPU, Max user IP already reached!");
            return false;
        }
        if (operatorData.maxPolicy < operatorData2.policyCnt) {
            this.d.error("ODcPU, Max policy already reached!");
            return false;
        }
        if (operatorData.maxWhitelist < operatorData2.whitelistCnt) {
            this.d.error("ODcPU, Max whitelist already reached!");
            return false;
        }
        if (operatorData.maxFreeTime < operatorData2.freeTimeCnt) {
            this.d.error("ODcPU, Max free-time already reached!");
            return false;
        }
        return this.a(operatorData);
    }

    private void f(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "delete from free_time where op_id = " + n2;
        b2.b(string);
        string = "delete from user where op_id = " + n2;
        b2.b(string);
        string = "delete from policy where op_id = " + n2;
        b2.b(string);
        string = "delete from operator where id = " + n2;
        b2.b(string);
        b2.close();
    }

    public boolean insert(OperatorData operatorData) {
        String string;
        b b2;
        boolean bl;
        operatorData.sanitize();
        if (!this.b(operatorData)) {
            return false;
        }
        if (!nxd.lib.c.g(operatorData.passwd)) {
            operatorData.passwd = DigestUtils.shaHex(operatorData.passwd);
        }
        if (!(bl = (b2 = DaoUtil.getDbTraffic()).d(string = nxd.c.h(operatorData.name)))) {
            this.d.error("Couldn't create traffic data tables for {}!", (Object)operatorData.name);
            return false;
        }
        b2 = DaoUtil.getDbConfig();
        string = "select use_trial_period from license_policy";
        boolean bl2 = b2.n(string);
        string = "insert into operator(name, description, passwd, email, alert_period";
        string = string + ", max_user, max_user_ip, max_policy, max_whitelist, max_free_time, type, exp_date, trial_flag)";
        string = string + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        bl = b2.d(string, new Object[]{operatorData.name, operatorData.description, operatorData.passwd, operatorData.email, operatorData.alertPeriod, operatorData.maxUser, operatorData.maxUserIp, operatorData.maxPolicy, operatorData.maxWhitelist, operatorData.maxFreeTime, operatorData.type, operatorData.expDate, nxd.lib.c.d(bl2)});
        if (!bl) {
            this.d.error("Couldn't create an operator account for {}!", (Object)operatorData.name);
            return false;
        }
        this.c.b("operator");
        OperatorData operatorData2 = this.selectOneByName(operatorData.name);
        PolicyDao policyDao = new PolicyDao(operatorData2.id);
        PolicyData policyData = new PolicyData();
        policyData.name = operatorData2.name;
        policyData.description = "Default policy for " + operatorData2.name;
        policyData.systemFlag = true;
        if (!policyDao.insert(policyData)) {
            this.f(operatorData2.id);
            return false;
        }
        policyData = policyDao.selectOneByName(policyData.name);
        UserDao userDao = new UserDao(operatorData2.id);
        UserData userData = new UserData();
        userData.name = operatorData2.name;
        userData.description = "Default user for " + operatorData2.name;
        userData.policyId = policyData.id;
        userData.ftPolicyId = policyData.id;
        userData.systemFlag = true;
        if (!userDao.insert(userData)) {
            this.f(operatorData2.id);
            return false;
        }
        FreeTimeDao freeTimeDao = new FreeTimeDao(operatorData2.id);
        FreeTimeData freeTimeData = new FreeTimeData();
        freeTimeData.stime = "1300";
        freeTimeData.etime = "1400";
        freeTimeData.wdayArr = new String[]{"2", "3", "4", "5", "6"};
        freeTimeData.description = "Lunch time";
        if (!freeTimeDao.insert(freeTimeData)) {
            this.f(operatorData2.id);
            return false;
        }
        freeTimeData = new FreeTimeData();
        freeTimeData.stime = "1800";
        freeTimeData.etime = "0900";
        freeTimeData.wdayArr = new String[]{"2", "3", "4", "5", "6"};
        freeTimeData.description = "Closed";
        if (!freeTimeDao.insert(freeTimeData)) {
            this.f(operatorData2.id);
            return false;
        }
        freeTimeData = new FreeTimeData();
        freeTimeData.stime = "0000";
        freeTimeData.etime = "2400";
        freeTimeData.wdayArr = new String[]{"7", "1"};
        freeTimeData.description = "Holiday";
        if (!freeTimeDao.insert(freeTimeData)) {
            this.f(operatorData2.id);
            return false;
        }
        PolicyProxyDao policyProxyDao = new PolicyProxyDao(operatorData2.id);
        policyProxyDao.createNew(operatorData2.id);
        PolicyCxBlockDao policyCxBlockDao = new PolicyCxBlockDao(operatorData2.id);
        policyCxBlockDao.createNew(operatorData2.id);
        PolicyNxProxyDao policyNxProxyDao = new PolicyNxProxyDao(operatorData2.id);
        policyNxProxyDao.createNew(operatorData2.id);
        return true;
    }

    public boolean isOperatorPw(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from operator where passwd = ? and id = ?", new Object[]{DigestUtils.shaHex(string), this.a});
        b2.close();
        return n2 > 0;
    }

    public boolean update(OperatorData operatorData) {
        Object object;
        operatorData.sanitize();
        if (!this.c(operatorData)) {
            return false;
        }
        if (!nxd.lib.c.g(operatorData.passwd)) {
            operatorData.passwd = DigestUtils.shaHex(operatorData.passwd);
        }
        if (nxd.lib.c.a(operatorData.email) && (object = new SignupRequestDao().selectOneByName(operatorData.name)) != null) {
            operatorData.email = ((SignupRequestData)object).email;
        }
        object = "update operator set passwd = ?, description = ?, stop_flag = ?";
        object = (String)object + ", email = ?, alert_period = ?, alert_category = ?, exp_date = ?, trial_flag = ?";
        object = (String)object + ", max_user = ?, max_user_ip = ?, max_policy = ?, max_whitelist = ?, max_free_time = ?, type = ?";
        object = (String)object + ", recv_alert_admin_block = ?";
        object = (String)object + ", recv_alert_category_block = ?";
        object = (String)object + ", recv_alert_unclassified = ?";
        object = (String)object + ", recv_alert_block_time = ?";
        object = (String)object + ", recv_alert_system_block = ?";
        object = (String)object + ", recv_alert_other_reasons = ?";
        object = (String)object + " where id = ?";
        boolean bl = DaoUtil.getDbConfig().b((String)object, new Object[]{operatorData.passwd, operatorData.description, nxd.lib.c.d(operatorData.stopFlag), operatorData.email, operatorData.alertPeriod, operatorData.alertCategory, operatorData.expDate, nxd.lib.c.d(operatorData.trialFlag), operatorData.maxUser, operatorData.maxUserIp, operatorData.maxPolicy, operatorData.maxWhitelist, operatorData.maxFreeTime, operatorData.type, nxd.lib.c.d(operatorData.recvAlertAdminBlock), nxd.lib.c.d(operatorData.recvAlertCategoryBlock), nxd.lib.c.d(operatorData.recvAlertUnclassified), nxd.lib.c.d(operatorData.recvAlertBlockTime), nxd.lib.c.d(operatorData.recvAlertSystemBlock), nxd.lib.c.d(operatorData.recvAlertOtherReasons), operatorData.id});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        if (!operatorData.stopFlag && DaoUtil.checkMaxUserForLicense(0)) {
            object = "update operator set stop_flag = 'TRUE' where id = ?";
            DaoUtil.getDbConfig().d((String)object, new Object[]{operatorData.id});
            this.d.error("ODcPU, Too many users license violation! Operator has been suspended");
        }
        this.c.b("operator");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateOperatorName(String string, String string2) {
        if (!ParamTest.isValidNameLen(string2)) {
            this.d.error("ODuPN, {}", (Object)ParamTest.ERR_NAME_LEN);
            return false;
        }
        if (!ParamTest.isValidUsernameChar(string2)) {
            this.d.error("ODuPN, {}", (Object)"Only alphabet, number, [.@-_] allowed in username.");
            return false;
        }
        if (ParamTest.isDupOperator(string2)) {
            this.d.error("ODuPN, Operator alerady exists!");
            return false;
        }
        if (ParamTest.isSameNameAsAdmin(string2)) {
            this.d.error("ODuPN, Operator name can't be same as admin!");
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            String string3 = "select id from operator where name = ?";
            int n2 = b2.f(string3, new Object[]{string});
            string3 = "update operator set name = ? where name = ?";
            b2.b(string3, new Object[]{string2, string});
            string3 = "update user set name = ? where name = ? and op_id = ? and system_flag = 'TRUE'";
            b2.b(string3, new Object[]{string2, string, n2});
            string3 = "update policy set name = ? where name = ? and op_id = ?";
            b2.b(string3, new Object[]{string2, string, n2});
        }
        return true;
    }

    public boolean resetOpReqCnt(String string) {
        nxd.i.b.a().f(string);
        return true;
    }

    public int getOpReqCnt(String string) {
        return nxd.lib.c.d(nxd.i.b.a().g(string));
    }

    public int calcOpMaxReqCnt(int n2, int n3) {
        int n4 = n2 * 4000;
        if (n3 == 2) {
            n4 += 20000;
        }
        return n4;
    }

    public int selectOperatorSum(String string, String string2, int n2) {
        if (!string2.matches("\\d{8}")) {
            this.d.error("OperatorDao.selectOperatorSum, sdate format error! - " + string2);
            return -1;
        }
        String string3 = nxd.lib.d.c("yyyyMMdd", string2, n2 * -1);
        String string4 = "select sum(req_cnt) from license_count_1d where opname = ? and cdate <= ? and cdate > ?";
        try (b b2 = DaoUtil.getDbOpStats();){
            int n3 = b2.f(string4, new Object[]{string, string2, string3});
            return n3;
        }
    }

    public String makeRandomPasswd() {
        return l.a(12).toLowerCase();
    }
}

