/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.exception.ZipException;
import nxd.a;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.GlobalDao;
import nxd.data.CategoryDomainData;
import nxd.data.JahaslistData;
import nxd.l.g;
import nxd.l.j;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.d;
import nxd.lib.e;
import nxd.lib.f;
import nxd.p;

public class JahaslistDao
extends FirstDao {
    public void addKw(String string) {
        if (this.searchOption.size() > 0) {
            return;
        }
        if (string.startsWith("__")) {
            string = string.replaceFirst("__", "");
            this.searchOption.addKw("domain", string, 2);
            return;
        }
        this.searchOption.addKw("domain", string, 4);
    }

    private String a() {
        String string = this.searchOption.toSql(12);
        if (nxd.lib.c.a(string)) {
            return "";
        }
        return " where " + string;
    }

    public int selectCount() {
        String string = this.a();
        int n2 = 0;
        try (b b2 = DaoUtil.getDbJahaslistMaster();){
            n2 = b2.f("select count(*) from domain_jahas" + string);
        }
        return n2;
    }

    private JahaslistData a(RowSet rowSet) {
        JahaslistData jahaslistData = new JahaslistData();
        jahaslistData.id = rowSet.getInt("id");
        jahaslistData.domain = rowSet.getString("domain");
        jahaslistData.categoryId = nxd.lib.c.d(rowSet.getString("category"));
        jahaslistData.categoryName = DaoUtil.getJahasCategoryName(jahaslistData.categoryId);
        return jahaslistData;
    }

    public List<JahaslistData> selectList() {
        ArrayList<JahaslistData> arrayList = new ArrayList<JahaslistData>();
        if (this.searchOption.size() == 0) {
            return arrayList;
        }
        String string = this.a();
        int n2 = nxd.lib.c.a(this.limit, this.page);
        String string2 = "select * from domain_jahas" + string;
        string2 = string2 + String.format(" order by id desc limit %s, %s", n2, this.limit);
        try (b b2 = DaoUtil.getDbJahaslistMaster();
             RowSet rowSet = b2.l(string2);){
            while (rowSet.next()) {
                arrayList.add(this.a(rowSet));
            }
        }
        return arrayList;
    }

    public boolean delete(int n2) {
        try (b b2 = DaoUtil.getDbJahaslistMaster();){
            String string = "select * from domain_jahas where id = ?";
            try (RowSet rowSet = b2.m(string, new Object[]{n2});){
                String string2 = rowSet.getString("domain");
                String string3 = rowSet.getString("category");
                int n3 = nxd.lib.c.d(string3);
                if (GlobalDao.isMasterNode()) {
                    string = "insert into cluster_sync(domain, category_id, action) values(?, ?, 2)";
                    b2.b(string, new Object[]{string2, n3});
                }
            }
            string = "delete from domain_jahas where id = ?";
            b2.b(string, new Object[]{n2});
        }
        return true;
    }

    public boolean deleteAll() {
        String string = "truncate table domain_jahas";
        try (b b2 = DaoUtil.getDbJahaslistMaster();){
            b2.b(string);
        }
        return true;
    }

    public boolean insert(JahaslistData jahaslistData) {
        String[] stringArray;
        jahaslistData.sanitize();
        for (String string : stringArray = jahaslistData.domain.split("\\s+")) {
            if (!f.e(string = string.trim()) || !string.contains(".")) {
                this.d.info("JDi, Invalid domain! - {}", (Object)string);
                continue;
            }
            try (b b2 = DaoUtil.getDbJahaslistLocal();){
                String string2 = "merge into domain_jahas(domain, category) key(domain) values(?, ?)";
                b2.b(string2, new Object[]{string, jahaslistData.categoryId + ""});
                if (!GlobalDao.isMasterNode()) continue;
                nxd.c.a.a(b2, string, jahaslistData.categoryId);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public Map<Integer, String> getJahasCategoryMap() {
        return DaoUtil.getJahasCategoryMap();
    }

    private void b() {
        if (a.a().Q != 5) {
            this.d.info("JahaslistDao.mergeToJahaslist, We don't merge custom classified domains as we are not using Jahaslist!");
            return;
        }
        String string = "select * from category_domain where category_id < 99";
        ArrayList<CategoryDomainData> arrayList = new ArrayList<CategoryDomainData>();
        try (b b2 = DaoUtil.getDbConfig();){
            Throwable object = null;
            try (RowSet rowSet = b2.l(string);){
                while (rowSet.next()) {
                    CategoryDomainData categoryDomainData = new CategoryDomainData();
                    categoryDomainData.categoryId = rowSet.getInt("category_id");
                    categoryDomainData.domain = rowSet.getString("domain");
                    if (nxd.lib.c.a(DaoUtil.getJahasCategoryName(categoryDomainData.categoryId))) continue;
                    categoryDomainData.domain = categoryDomainData.domain.replaceFirst("^www\\.", "");
                    categoryDomainData.domain = categoryDomainData.domain.replaceFirst("^\\*\\.", "");
                    arrayList.add(categoryDomainData);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
        }
        string = "merge into domain_jahas(domain, category) key(domain) values(?, ?)";
        b2 = DaoUtil.getDbJahaslistMaster();
        var4_4 = null;
        try {
            for (CategoryDomainData categoryDomainData : arrayList) {
                if (!f.e(categoryDomainData.domain)) {
                    this.d.info("JDmTJ, Invalid domain! - {}", (Object)categoryDomainData.domain);
                    continue;
                }
                b2.b(string, new Object[]{categoryDomainData.domain, categoryDomainData.categoryId});
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (b2 != null) {
                if (var4_4 != null) {
                    try {
                        b2.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    b2.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportFile() {
        this.b();
        String string = "jahaslist_" + nxd.lib.d.a("yyyyMMddHHmm");
        String string2 = p.l + "/" + string;
        String string3 = p.l + "/" + string + ".nxz";
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-8"));){
            String string4 = "select * from domain_jahas order by domain";
            try (b b2 = DaoUtil.getDbJahaslistMaster();
                 RowSet rowSet = b2.l(string4);){
                int n2 = 0;
                while (rowSet.next()) {
                    String string5 = rowSet.getString("domain");
                    String string6 = rowSet.getString("category");
                    if (n2++ > 0) {
                        bufferedWriter.write("\n");
                    }
                    bufferedWriter.write(string5);
                    bufferedWriter.write(",");
                    bufferedWriter.write(string6);
                }
            }
            nxd.l.p.a(string2, string3, "nxz1283%T");
        }
        catch (Exception exception) {
            this.d.error("JahaslistDao.exportFile, {}", (Object)exception.toString());
            String string7 = "";
            return string7;
        }
        finally {
            e.q(string2);
        }
        return string3;
    }

    public int importFile(String string) {
        return this.importFile(string, false, true);
    }

    public int importFile(String string, boolean bl) {
        return this.importFile(string, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importFile(String string, boolean bl, boolean bl2) {
        String string2 = string;
        if (string.endsWith(".nxz")) {
            try {
                string2 = nxd.l.p.a(string, "nxz1283%T");
            }
            catch (ZipException zipException) {
                this.d.error("JahaslistDao.importFile, {}", (Object)zipException.toString());
                int n2 = 0;
                return n2;
            }
            finally {
                e.q(string);
            }
        }
        Map<Integer, String> map = DaoUtil.getJahasCategoryMap();
        int n3 = 0;
        b b2 = null;
        b2 = bl ? DaoUtil.getDbJahaslistLocal() : DaoUtil.getDbJahaslistMaster();
        String string3 = "merge into domain_jahas(domain, category) key(domain) values(?, ?)";
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));){
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (n3 % 20000 == 0) {
                    if (b2 != null) {
                        b2.close();
                    }
                    nxd.lib.c.b(500);
                    b2 = bl ? DaoUtil.getDbJahaslistLocal() : DaoUtil.getDbJahaslistMaster();
                }
                if ((stringArray = string4.split(",")).length != 2) continue;
                String string5 = stringArray[0];
                int n4 = nxd.lib.c.d(stringArray[1]);
                if (string5.contains("/")) {
                    this.d.debug("JahaslistDao.importFile, Invalid domain = {}", (Object)string5);
                    continue;
                }
                if (!f.e(string5)) {
                    this.d.debug("JahaslistDao.importFile, Invalid domain = {}", (Object)string5);
                    continue;
                }
                if (n4 > 99) continue;
                if (b2.b(string3, new Object[]{string5, n4 + ""})) {
                    ++n3;
                }
                if (n3 <= 0 || n3 % 1000 != 0) continue;
                this.d.info("JDiF, Processsing = {}", (Object)n3);
            }
        }
        catch (Exception exception) {
            this.d.error("JDiF, {}", (Object)exception.toString());
        }
        finally {
            if (bl2) {
                e.q(string2);
            }
        }
        if (b2 != null) {
            b2.close();
        }
        if (n3 > 0) {
            this.d.info("JDiF, Processed data = {}", (Object)n3);
            nxd.i.b.a().g();
        }
        return n3;
    }

    public int importFileNewDomainOnly(String string) {
        return this.importFileNewDomainOnly(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importFileNewDomainOnly(String string, boolean bl) {
        String string2 = string;
        if (string.endsWith(".nxz")) {
            try {
                string2 = nxd.l.p.a(string, "nxz1283%T");
            }
            catch (ZipException zipException) {
                this.d.error("JahaslistDao.importFile, {}", (Object)zipException.toString());
                int n2 = 0;
                return n2;
            }
            finally {
                e.q(string);
            }
        }
        Map<Integer, String> map = DaoUtil.getJahasCategoryMap();
        int n3 = 0;
        int n4 = 0;
        b b2 = null;
        b2 = bl ? DaoUtil.getDbJahaslistLocal() : DaoUtil.getDbJahaslistMaster();
        String string3 = "select count(*) from domain_jahas where domain = ?";
        String string4 = "insert into domain_jahas(domain, category) values(?, ?)";
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));){
            String string5 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (++n3 % 20000 == 0) {
                    if (b2 != null) {
                        b2.close();
                    }
                    nxd.lib.c.b(500);
                    b2 = DaoUtil.getDbJahaslistMaster();
                }
                if (n3 > 0 && n3 % 1000 == 0) {
                    this.d.info("JDiFNDO, Processsing = {}", (Object)n3);
                }
                if ((stringArray = string5.split(",")).length != 2) continue;
                String string6 = stringArray[0];
                int n5 = nxd.lib.c.d(stringArray[1]);
                if (!map.containsKey(n5) || b2.f(string3, new Object[]{string6}) > 0 || !b2.b(string4, new Object[]{string6, n5 + ""})) continue;
                ++n4;
            }
        }
        catch (Exception exception) {
            this.d.error("JDiFNDO, {}", (Object)exception.toString());
        }
        finally {
            e.q(string2);
        }
        if (b2 != null) {
            b2.close();
        }
        if (n3 > 0) {
            this.d.info("JDiFNDO, Processed data = {}", (Object)n3);
        }
        e.q(string2);
        return n4;
    }

    public boolean restoreDefault() {
        boolean bl = new j().a();
        if (bl) {
            nxd.i.b.a().g();
        }
        return bl;
    }

    public String[] getUpdateInfoArr() {
        String[] stringArray = j.d();
        if (stringArray == null || stringArray.length < 2) {
            return new String[]{"", ""};
        }
        stringArray[0] = g.b(stringArray[0]);
        return stringArray;
    }

    public void sanitizeJahaslist() {
        try (b b2 = DaoUtil.getDbJahaslistLocal();){
            String string = "update domain_jahas set category = '99' where domain regexp '^com\\..{2}$';\nupdate domain_jahas set category = '99' where domain regexp '^org\\..{2}$';\nupdate domain_jahas set category = '99' where domain regexp '^net\\..{2}$';\nupdate domain_jahas set category = '99' where domain regexp '^co\\..{2}$';";
            b2.b(string);
        }
        catch (Exception exception) {
            this.d.error("JahaslistDao.sanitizeJahaslist, " + exception.toString());
        }
    }
}

