/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.FreeTimeData;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;

public class FreeTimeDao
extends FirstDao {
    int a = 0;

    public FreeTimeDao(int n2) {
        this.a = n2;
    }

    public int selectCount() {
        b b2 = DaoUtil.getDbConfig();
        String string = String.format("select count(*) from free_time where op_id = %d", this.a);
        int n2 = b2.f(string);
        b2.close();
        return n2;
    }

    public List<FreeTimeData> selectList() {
        ArrayList<FreeTimeData> arrayList = new ArrayList<FreeTimeData>();
        b b2 = DaoUtil.getDbConfig();
        String string = String.format("select * from free_time where op_id = %d order by stime", this.a);
        RowSet rowSet = b2.l(string);
        while (rowSet.next()) {
            FreeTimeData freeTimeData = new FreeTimeData();
            freeTimeData.id = rowSet.getInt("id");
            freeTimeData.stime = rowSet.getString("stime");
            freeTimeData.etime = rowSet.getString("etime");
            freeTimeData.wday = rowSet.getString("wday");
            freeTimeData.description = rowSet.getString("description");
            arrayList.add(freeTimeData);
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    public boolean isValidOwner(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) from free_time where id = ? and op_id = ?";
        int n3 = b2.f(string, new Object[]{n2, this.a});
        b2.close();
        return n3 > 0;
    }

    public boolean delete(int n2) {
        String string;
        if (this.a > 0 && !this.isValidOwner(n2)) {
            this.d.error("FreeTimeDao.delete, Not a valid owner!");
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        boolean bl = b2.d(string = "delete from free_time where id = ?", new Object[]{n2});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("free_time");
        return true;
    }

    private boolean a(FreeTimeData freeTimeData) {
        if (!DaoUtil.isOperatorId(this.a)) {
            this.d.error("FTDcP, No operator found!");
            return false;
        }
        if (freeTimeData.wdayArr == null || freeTimeData.wdayArr.length == 0) {
            this.d.error("FTDcP, No weekday selected!");
            return false;
        }
        for (String string : freeTimeData.wdayArr) {
            int n2 = nxd.lib.c.d(string);
            if (n2 >= 1 && n2 <= 7) continue;
            this.d.error("FTDcP, Invalid day found!");
            return false;
        }
        return true;
    }

    public boolean insert(FreeTimeData freeTimeData) {
        freeTimeData.sanitize();
        if (!this.a(freeTimeData)) {
            return false;
        }
        if (ParamTest.hasMaxFreeTimeForOperator(this.a)) {
            this.d.error("FreeTimeDao.insert, Can't add more free-time!");
            return false;
        }
        if (nxd.lib.c.a(freeTimeData.wday)) {
            freeTimeData.wday = nxd.lib.c.a(freeTimeData.wdayArr, ",");
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "insert into free_time(stime, etime, wday, description, op_id) values(?, ?, ?, ?, ?)";
        boolean bl = b2.d(string, new Object[]{freeTimeData.stime, freeTimeData.etime, freeTimeData.wday, freeTimeData.description, this.a});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("free_time");
        return true;
    }
}

