/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nxd.d.s;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.dao.UnivCache;
import nxd.data.ConfigData;
import nxd.l.g;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.d;
import nxd.lib.e;
import nxd.lib.f;
import nxd.p;

public class ConfigDao
extends FirstDao {
    private boolean a(ConfigData configData) {
        if (!ParamTest.isValidBlockIp(configData.blockRediIp)) {
            this.d.error("CDcP, Invalid block redirection IP!");
            return false;
        }
        if (nxd.lib.c.b(configData.rfBlockRediIp) && !ParamTest.isValidBlockIp(configData.rfBlockRediIp)) {
            this.d.error("CDcP, Invalid External redirection IP!");
            return false;
        }
        if (nxd.lib.c.b(configData.ipv6BlockRediIp) && !f.c(configData.ipv6BlockRediIp)) {
            this.d.error("CDcP, Invalid IPv6 redirection IP!");
            return false;
        }
        if (!f.e(configData.loginDomain)) {
            this.d.error("CDcP, Invalid login domain!");
            return false;
        }
        if (!f.e(configData.logoutDomain)) {
            this.d.error("CDcP, Invalid logout domain!");
            return false;
        }
        if (nxd.lib.c.b(configData.syslogHost) && !f.b(configData.syslogHost)) {
            this.d.error("CDcP, Invalid IP address for Syslog host!");
            return false;
        }
        if (configData.remoteLogging && nxd.lib.c.a(configData.syslogHost)) {
            this.d.error("CDcP, Remote logging option requires syslog host!");
            return false;
        }
        if (!f.e(configData.adminDomain)) {
            this.d.error("CDcP, Invalid admin domain!");
            return false;
        }
        return true;
    }

    public ConfigData selectOne() {
        ConfigData configData = new ConfigData();
        b b2 = DaoUtil.getDbConfig();
        String string = "select * from config";
        RowSet rowSet = b2.m(string);
        configData.blockRediIp = rowSet.getString("block_redi_ip");
        configData.silentBlock = rowSet.str2bool("silent_block");
        configData.rfBlockRediIp = rowSet.getString("rf_block_redi_ip");
        configData.ipv6BlockRediIp = rowSet.getString("ipv6_block_redi_ip");
        configData.enableLogin = rowSet.str2bool("enable_login");
        configData.loginDomain = rowSet.getString("login_domain");
        configData.logoutDomain = rowSet.getString("logout_domain");
        configData.loginSessionTtl = rowSet.getInt("login_session_ttl");
        configData.enableLoginRedirection = rowSet.str2bool("enable_login_redirection");
        configData.syslogHost = rowSet.getString("syslog_host");
        configData.syslogPort = rowSet.getInt("syslog_port");
        configData.exportBlockedOnly = rowSet.str2bool("export_blocked_only");
        configData.fromEachNode = rowSet.str2bool("from_each_node");
        configData.syslogJson = rowSet.str2bool("syslog_json");
        configData.remoteLogging = rowSet.str2bool("remote_logging");
        configData.fileExport = rowSet.str2bool("file_export");
        configData.adminDomain = rowSet.getString("admin_domain");
        configData.bypassMsUpdate = rowSet.str2bool("bypass_ms_update");
        configData.logRetentionDays = rowSet.getInt("log_retention_days");
        configData.sslOnly = rowSet.str2bool("ssl_only");
        configData.autoBackupDays = rowSet.getInt("auto_backup_days");
        configData.agentPolicyUpdatePeriod = rowSet.getInt("agent_policy_update_period");
        configData.aQueryOnly = rowSet.str2bool("a_query_only");
        configData.disableVersionCheck = rowSet.str2bool("disable_version_check");
        rowSet.close();
        b2.close();
        Map<String, String> map = e.d(p.b);
        configData.guiLang = nxd.lib.c.a((Object)map.get("gui_lang"));
        configData.guiDateFormat = nxd.lib.c.a((Object)map.get("date_display"));
        return configData;
    }

    public ConfigData selectOneLocal() {
        ConfigData configData = new ConfigData();
        b b2 = DaoUtil.getDbLocal();
        String string = "select * from config";
        RowSet rowSet = b2.m(string);
        configData.enableLogin = rowSet.str2bool("enable_login");
        configData.loginDomain = rowSet.getString("login_domain");
        configData.logoutDomain = rowSet.getString("logout_domain");
        configData.enableLoginRedirection = rowSet.str2bool("enable_login_redirection");
        rowSet.close();
        b2.close();
        return configData;
    }

    public boolean update(ConfigData configData) {
        configData.sanitize();
        if (!this.a(configData)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "update config set block_redi_ip = ?, silent_block = ?, rf_block_redi_ip = ?, ipv6_block_redi_ip = ?, enable_login = ?";
        string = string + ", enable_login_redirection = ?, login_domain = ?, logout_domain = ?, login_session_ttl = ?";
        string = string + ", syslog_host = ?, syslog_port = ?, export_blocked_only = ?, from_each_node = ?";
        string = string + ", syslog_json = ?, remote_logging = ?, file_export = ?";
        string = string + ", admin_domain = ?, bypass_ms_update = ?, log_retention_days = ?";
        string = string + ", ssl_only = ?, auto_backup_days = ?, agent_policy_update_period = ?";
        string = string + ", a_query_only = ?, disable_version_check = ?";
        boolean bl = b2.d(string, new Object[]{configData.blockRediIp, nxd.lib.c.d(configData.silentBlock), configData.rfBlockRediIp, configData.ipv6BlockRediIp, nxd.lib.c.d(configData.enableLogin), nxd.lib.c.d(configData.enableLoginRedirection), configData.loginDomain, configData.logoutDomain, configData.loginSessionTtl, configData.syslogHost, configData.syslogPort, nxd.lib.c.d(configData.exportBlockedOnly), nxd.lib.c.d(configData.fromEachNode), nxd.lib.c.d(configData.syslogJson), nxd.lib.c.d(configData.remoteLogging), nxd.lib.c.d(configData.fileExport), configData.adminDomain, nxd.lib.c.d(configData.bypassMsUpdate), configData.logRetentionDays, nxd.lib.c.d(configData.sslOnly), configData.autoBackupDays, configData.agentPolicyUpdatePeriod, nxd.lib.c.d(configData.aQueryOnly), nxd.lib.c.d(configData.disableVersionCheck)});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        if (nxd.lib.c.b(configData.guiLang)) {
            e.d(p.b, "gui_lang", configData.guiLang);
            s.a().a(configData.guiLang);
        }
        if (nxd.lib.c.b(configData.guiDateFormat)) {
            e.d(p.b, "date_display", configData.guiDateFormat);
        }
        this.c.b("config");
        return true;
    }

    public String backup() {
        String string = String.format("config-%s.zip", nxd.lib.d.a("yyyyMMddHHmmss"));
        String string2 = String.format("%s/%s", p.l, string);
        b b2 = DaoUtil.getDbConfig();
        String string3 = String.format("backup to '%s'", string2);
        boolean bl = b2.d(string3);
        if (!bl) {
            this.d.error("DB error!");
            return "";
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUptimeInfo() {
        try (b b2 = DaoUtil.getDbConfig();){
            int n2 = b2.f("select start_time from config");
            int n3 = nxd.lib.d.a() - n2;
            int n4 = n3 / 86400;
            int n5 = (n3 %= 86400) / 3600;
            int n6 = (n3 %= 3600) / 60;
            String string2 = n4 + " days";
            if (n4 == 1) {
                string2 = "1 day";
            }
            String string = String.format("%s %02d:%02d", string2, n5, n6);
            return string;
        }
        catch (Exception exception) {
            return "0 day 00:00";
        }
    }

    public String getStartTime() {
        try (b b2 = DaoUtil.getDbConfig();){
            int n2 = b2.f("select start_time from config");
            String string = nxd.lib.d.a("yyyyMMddHHmm", n2);
            String string2 = g.c(string);
            return string2;
        }
    }

    public List<String[]> getGuiLangList() {
        return UnivCache.getInstance().getGuiLangList();
    }

    public List<String[]> getGuiDateFormatList() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"y-m-d", "y-m-d, ex) 2021-01-31"});
        arrayList.add(new String[]{"y/m/d", "y/m/d, ex) 2021/01/31"});
        arrayList.add(new String[]{"d/m/y", "d/m/y, ex) 31/01/2021"});
        arrayList.add(new String[]{"d.m.y", "d.m.y, ex) 31.01.2021"});
        arrayList.add(new String[]{"m/d/y", "m/d/y, ex) 01/31/2021"});
        arrayList.add(new String[]{"m.d.y", "m.d.y, ex) 01.31.2021"});
        return arrayList;
    }
}

