/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nxd.c;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.ClassifierRulesetData;
import nxd.l.j;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.e;
import nxd.p;

public class ClassifierRulesetDao
extends FirstDao {
    public void addKw(String string) {
        if (this.searchOption.size() > 0) {
            return;
        }
        this.searchOption.addKw("keyword", string, 2);
        this.searchOption.addKw("category_name", string, 2);
    }

    private String a() {
        String string = this.searchOption.toSql(12);
        if (nxd.lib.c.a(string)) {
            return "";
        }
        return " where " + string;
    }

    private String b() {
        String string = nxd.c.s();
        String string2 = this.a();
        if (nxd.lib.c.a(string2)) {
            return string;
        }
        return "select * from (" + string + ")" + string2;
    }

    public int selectCount() {
        try (b b2 = DaoUtil.getDbConfig();){
            String string = this.b();
            String string2 = "select count(*) from (" + string + ")";
            int n2 = b2.f(string2);
            return n2;
        }
    }

    public boolean delete(int n2) {
        String string = "delete from classifier_ruleset where id = ?";
        try (b b2 = DaoUtil.getDbConfig();){
            b2.b(string, new Object[]{n2});
        }
        this.c.b("classifier_ruleset");
        return true;
    }

    public boolean deleteAll() {
        String string = "delete from classifier_ruleset";
        try (b b2 = DaoUtil.getDbConfig();){
            b2.b(string);
        }
        this.c.b("classifier_ruleset");
        return true;
    }

    public boolean resetHits() {
        String string = "update classifier_ruleset set hits = 0";
        try (b b2 = DaoUtil.getDbConfig();){
            b2.b(string);
        }
        return true;
    }

    public ClassifierRulesetData fillData(RowSet rowSet) {
        ClassifierRulesetData classifierRulesetData = new ClassifierRulesetData();
        classifierRulesetData.id = rowSet.getInt("id");
        classifierRulesetData.target = rowSet.getString("target");
        classifierRulesetData.keyword = rowSet.getString("keyword");
        classifierRulesetData.points = rowSet.getInt("points");
        classifierRulesetData.hits = rowSet.getInt("hits");
        classifierRulesetData.categoryId = rowSet.getInt("category_id");
        classifierRulesetData.categoryName = rowSet.getString("category_name");
        return classifierRulesetData;
    }

    public List<ClassifierRulesetData> selectList() {
        int n2 = nxd.lib.c.a(this.limit, this.page);
        ArrayList<ClassifierRulesetData> arrayList = new ArrayList<ClassifierRulesetData>();
        String string = this.b();
        string = string + String.format(" order by category_name asc, points desc, id asc limit %s, %s", n2, this.limit);
        try (b b2 = DaoUtil.getDbConfig();
             RowSet rowSet = b2.l(string);){
            while (rowSet.next()) {
                arrayList.add(this.fillData(rowSet));
            }
        }
        return arrayList;
    }

    public boolean exportFile(String string) {
        this.page = 0;
        this.limit = 100000;
        List<ClassifierRulesetData> list = this.selectList();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (ClassifierRulesetData classifierRulesetData : list) {
            classifierRulesetData.keyword = ClassifierRulesetData.toFileKeyword(classifierRulesetData.keyword);
            if (n2++ > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(String.format("%s,%s,%s,%s", classifierRulesetData.target, classifierRulesetData.keyword, classifierRulesetData.points, classifierRulesetData.categoryId));
        }
        return e.c(p.l + "/" + string, stringBuilder.toString().trim(), "UTF-8");
    }

    public int importFile(String string, boolean bl) {
        String[] stringArray;
        if (bl && !this.deleteAll()) {
            return 0;
        }
        Map<Integer, String> map = DaoUtil.getJahasCategoryMap();
        int n2 = 0;
        for (String string2 : stringArray = e.f(string, "UTF-8")) {
            String[] stringArray2;
            if (nxd.lib.c.a(string2 = string2.trim()) || string2.startsWith("#") || (stringArray2 = string2.split(",")).length != 4) continue;
            ClassifierRulesetData classifierRulesetData = new ClassifierRulesetData();
            classifierRulesetData.target = stringArray2[0];
            classifierRulesetData.keyword = stringArray2[1];
            classifierRulesetData.points = nxd.lib.c.d(stringArray2[2]);
            classifierRulesetData.categoryId = nxd.lib.c.d(stringArray2[3]);
            classifierRulesetData.keyword = ClassifierRulesetData.toDbKeyword(classifierRulesetData.keyword);
            if (!map.containsKey(classifierRulesetData.categoryId)) {
                this.d.info("CRDiF, Category not found! - {}", (Object)classifierRulesetData.keyword);
                continue;
            }
            if (!ParamTest.isValidClassificationRule(classifierRulesetData.keyword)) {
                this.d.info("CRDiF, Invalid RegEx! - {}", (Object)classifierRulesetData.keyword);
                continue;
            }
            if (!this.insert(classifierRulesetData, false)) continue;
            ++n2;
        }
        this.c.b("classifier_ruleset");
        return n2;
    }

    public int importFile(String string) {
        int n2 = this.importFile(string, true);
        if (n2 > 0) {
            this.c();
        }
        return n2;
    }

    private boolean a(ClassifierRulesetData classifierRulesetData) {
        if (nxd.lib.c.a(classifierRulesetData.keyword)) {
            this.d.error("CRDcP, Invalid keyword!");
            return false;
        }
        if (classifierRulesetData.keyword.contains("||") || classifierRulesetData.keyword.contains("(|") || classifierRulesetData.keyword.contains("|)")) {
            this.d.error("CRDcP, Invalid keyword!");
            return false;
        }
        if (!ParamTest.isValidClassificationRule(classifierRulesetData.keyword)) {
            this.d.error("CRDcP, {}", (Object)"Not a valid classfication rule.");
            return false;
        }
        return true;
    }

    private boolean b(ClassifierRulesetData classifierRulesetData) {
        if (!this.a(classifierRulesetData)) {
            return false;
        }
        if (ParamTest.isDupClassificationRule(classifierRulesetData.target, classifierRulesetData.keyword, classifierRulesetData.categoryId)) {
            this.d.error("CRDcPI, Rule already exists! - {}", (Object)classifierRulesetData.keyword);
            return false;
        }
        Map<Integer, String> map = DaoUtil.getJahasCategoryMap();
        if (classifierRulesetData.categoryId == 0 || !map.containsKey(classifierRulesetData.categoryId)) {
            this.d.error("CRDcPI, Invalid category!");
            return false;
        }
        return true;
    }

    public boolean insert(ClassifierRulesetData classifierRulesetData, boolean bl) {
        classifierRulesetData.sanitize();
        if (!this.b(classifierRulesetData)) {
            return false;
        }
        String string = "insert into classifier_ruleset(target, keyword, points, category_id) values(?, ?, ?, ?)";
        try (b b2 = DaoUtil.getDbConfig();){
            b2.b(string, new Object[]{classifierRulesetData.target, classifierRulesetData.keyword, classifierRulesetData.points, classifierRulesetData.categoryId});
        }
        if (bl) {
            this.c.b("classifier_ruleset");
        }
        return true;
    }

    private void c() {
        try (b b2 = DaoUtil.getDbConfig();){
            b2.b("update classifier_setup set mod_cnt = mod_cnt + 1");
        }
    }

    public boolean insert(ClassifierRulesetData classifierRulesetData) {
        boolean bl = this.insert(classifierRulesetData, true);
        if (bl) {
            this.c();
        }
        return bl;
    }

    public boolean update(ClassifierRulesetData classifierRulesetData) {
        classifierRulesetData.sanitize();
        if (!this.a(classifierRulesetData)) {
            return false;
        }
        String string = "update classifier_ruleset set keyword = ?, points = ? where id = ?";
        try (b b2 = DaoUtil.getDbConfig();){
            b2.b(string, new Object[]{classifierRulesetData.keyword, classifierRulesetData.points, classifierRulesetData.id});
        }
        this.c();
        this.c.b("classifier_ruleset");
        return true;
    }

    public Map<String, String> getTargetMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("T", "TITLE");
        linkedHashMap.put("A", "DOMAIN");
        linkedHashMap.put("D", "DESCRIPTION");
        linkedHashMap.put("K", "KEYWORDS");
        linkedHashMap.put("P", "DTDK TEXT");
        linkedHashMap.put("X", "BODY TEXT");
        return linkedHashMap;
    }

    public Map<Integer, String> getJahasCategoryMap() {
        return DaoUtil.getJahasCategoryMap();
    }

    public boolean restoreDefault() {
        if (new j().b()) {
            this.c.b("classifier_ruleset");
            return true;
        }
        return false;
    }
}

