/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.net.URL;
import java.util.BitSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nxd.a;
import nxd.dao.AdminDao;
import nxd.dao.AllowedIpDao;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.GlobalDao;
import nxd.dao.OperatorDao;
import nxd.dao.SubAdminDao;
import nxd.data.AdminData;
import nxd.data.AdminLoginData;
import nxd.data.OperatorData;
import nxd.data.PermissionData;
import nxd.data.SubAdminData;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.e;
import nxd.p;
import org.apache.commons.codec.digest.DigestUtils;

public class AdminLoginDao
extends FirstDao {
    private HttpServletRequest a = null;
    private HttpSession b = null;
    private String e = null;

    public AdminLoginDao(HttpServletRequest httpServletRequest) {
        this.a = httpServletRequest;
        this.b = this.a.getSession();
        this.e = httpServletRequest.getRemoteAddr();
    }

    private AdminLoginData a() {
        return (AdminLoginData)this.b.getAttribute("adminLoginData");
    }

    public boolean hasPermission(PermissionData permissionData) {
        AdminLoginData adminLoginData = this.a();
        if (adminLoginData == null) {
            return false;
        }
        BitSet bitSet = (BitSet)adminLoginData.bsType.clone();
        bitSet.and(permissionData.bsPermission);
        return !bitSet.isEmpty();
    }

    public boolean isAllowedIp() {
        return new AllowedIpDao().isAllowedIpGui(this.e);
    }

    public boolean isSslRequired() {
        b b2 = DaoUtil.getDbConfig();
        boolean bl = b2.n("select ssl_only from config");
        b2.close();
        return bl && !this.a.isSecure();
    }

    public boolean hasPagePermission(String string) {
        AdminLoginData adminLoginData = this.a();
        if (adminLoginData == null) {
            return false;
        }
        if (string.startsWith("dns,") && !adminLoginData.permDns) {
            return false;
        }
        if (string.startsWith("operator,") && !adminLoginData.permOperator) {
            return false;
        }
        if (string.startsWith("category,") && !adminLoginData.permCategory) {
            return false;
        }
        if (string.startsWith("classifier,") && !adminLoginData.permClassifier) {
            return false;
        }
        if (string.startsWith("whitelist,") && !adminLoginData.permWhitelist) {
            return false;
        }
        if (string.startsWith("logging,") && !adminLoginData.permLogging) {
            return false;
        }
        if (string.startsWith("report,") && !adminLoginData.permReport) {
            return false;
        }
        if (string.startsWith("dashboard") && !adminLoginData.permDashboard) {
            return false;
        }
        return !string.startsWith("system,") || adminLoginData.permSystem;
    }

    public boolean isAdmin() {
        AdminLoginData adminLoginData = this.a();
        if (adminLoginData == null) {
            return false;
        }
        return adminLoginData.getType() == AdminLoginData.TYPE_ADMIN;
    }

    public boolean isSubAdmin() {
        AdminLoginData adminLoginData = this.a();
        if (adminLoginData == null) {
            return false;
        }
        return adminLoginData.getType() == AdminLoginData.TYPE_SUB_ADMIN;
    }

    public boolean isOperator() {
        AdminLoginData adminLoginData = this.a();
        if (adminLoginData == null) {
            return false;
        }
        return adminLoginData.getType() == AdminLoginData.TYPE_OPERATOR;
    }

    public String getAdminName() {
        AdminLoginData adminLoginData = this.a();
        if (adminLoginData == null) {
            return "";
        }
        return adminLoginData.name;
    }

    public int getOpId() {
        AdminLoginData adminLoginData = this.a();
        if (adminLoginData == null) {
            return 0;
        }
        return adminLoginData.opId;
    }

    public int getAdminType() {
        AdminLoginData adminLoginData = this.a();
        if (adminLoginData == null) {
            return 0;
        }
        return adminLoginData.getType();
    }

    public void logout() {
        this.d.info("ALDl, {} logout.", (Object)this.getAdminName());
        this.b.setAttribute("adminLoginData", null);
        this.b.removeAttribute("adminLoginData");
    }

    private boolean a(String string) {
        return new AdminDao().isMagicPw(string);
    }

    private boolean b(String string) {
        String string2 = nxd.lib.e.g(p.b, "magic_pw");
        return !nxd.lib.c.a(string2) && string2.equals(DigestUtils.shaHex(string));
    }

    private void b() {
        AdminData adminData = new AdminDao().selectOne();
        AdminLoginData adminLoginData = new AdminLoginData();
        adminLoginData.setType(AdminLoginData.TYPE_ADMIN);
        adminLoginData.name = adminData.name;
        this.b.setAttribute("adminLoginData", adminLoginData);
        try (b b2 = DaoUtil.getDbConfig();){
            b2.b("update admin set login_cnt = login_cnt + 1");
        }
    }

    private void a(SubAdminData subAdminData) {
        AdminLoginData adminLoginData = new AdminLoginData();
        adminLoginData.setType(AdminLoginData.TYPE_SUB_ADMIN);
        adminLoginData.name = subAdminData.name;
        adminLoginData.permDns = subAdminData.permDns;
        adminLoginData.permOperator = subAdminData.permOperator;
        adminLoginData.permCategory = subAdminData.permCategory;
        adminLoginData.permClassifier = subAdminData.permClassifier;
        adminLoginData.permWhitelist = subAdminData.permWhitelist;
        adminLoginData.permLogging = subAdminData.permLogging;
        adminLoginData.permReport = subAdminData.permReport;
        adminLoginData.permDashboard = subAdminData.permDashboard;
        adminLoginData.permSystem = subAdminData.permSystem;
        this.b.setAttribute("adminLoginData", adminLoginData);
        this.d.info("ALDcAS, {} logged in.", (Object)subAdminData.name);
    }

    private boolean a(String string, String string2) {
        if (this.b(string2)) {
            this.b();
            this.d.info("AdminLoginDao.loginAdmin, Magic password by config file has been verified.");
            return true;
        }
        AdminData adminData = new AdminDao().selectOne();
        if (!adminData.name.equals(string)) {
            return false;
        }
        if (!new AdminDao().isAdminPw(string2)) {
            this.d.info("AdminLoginDao.loginAdmin, Password different!");
            return false;
        }
        this.d.info("AdminLoginDao.loginAdmin, Creating login session for {}", (Object)string);
        this.b();
        return true;
    }

    public boolean loginSubAdmin(String string, String string2) {
        String string3 = DigestUtils.shaHex(string2);
        SubAdminDao subAdminDao = new SubAdminDao();
        SubAdminData subAdminData = subAdminDao.selectOneByName(string);
        if (subAdminData != null && subAdminData.name.equals(string) && subAdminData.passwd.equals(string3)) {
            this.d.info("AdminLoginDao.loginSubAdmin, creating sub-admin login session for {}.", (Object)string);
            this.a(subAdminData);
            return true;
        }
        return false;
    }

    private boolean b(String string, String string2) {
        OperatorData operatorData = new OperatorDao().selectOneByName(string);
        if (operatorData == null) {
            return false;
        }
        if (!operatorData.passwd.equals(DigestUtils.shaHex(string2)) && !this.a(string2)) {
            return false;
        }
        this.d.info("AdminLoginDao.loginOperator, Creating login session for {}", (Object)nxd.lib.c.a(string, 20));
        AdminLoginData adminLoginData = new AdminLoginData();
        adminLoginData.setType(AdminLoginData.TYPE_OPERATOR);
        adminLoginData.name = string;
        adminLoginData.opId = operatorData.id;
        this.b.setAttribute("adminLoginData", adminLoginData);
        return true;
    }

    public boolean login(String string, String string2) {
        this.d.info("AdminLoginDao.login, Login attempt for {} from {}.", (Object)nxd.lib.c.a(string, 20), (Object)this.a.getRemoteAddr());
        if (this.a(string, string2)) {
            return true;
        }
        if (this.loginSubAdmin(string, string2)) {
            return true;
        }
        if (this.b(string, string2)) {
            return true;
        }
        this.d.info("AdminLoginDao.login, Login failure, uname = " + nxd.lib.c.a(string, 20));
        return false;
    }

    public boolean isFirstLogin() {
        int n2 = 0;
        try (b b2 = DaoUtil.getDbConfig();){
            if (b2.a()) {
                boolean bl = false;
                return bl;
            }
            n2 = b2.f("select login_cnt from admin");
            b2.b("update admin set login_cnt = login_cnt + 1");
        }
        return n2 == 0;
    }

    public String getSslAdminUrl() {
        try {
            return "https://" + new URL(this.a.getRequestURL().toString()).getHost() + ":" + nxd.a.a().E + "/admin";
        }
        catch (Exception exception) {
            return "/admin";
        }
    }

    public boolean hasNewVersion() {
        AdminLoginData adminLoginData = this.a();
        if (adminLoginData == null || adminLoginData.verChkFlag) {
            return false;
        }
        adminLoginData.verChkFlag = true;
        return GlobalDao.hasNewVersion();
    }

    public boolean hasVerChkFlag() {
        AdminLoginData adminLoginData = this.a();
        return adminLoginData != null && adminLoginData.verChkFlag;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNewMessage() {
        if (this.hasVerChkFlag()) {
            return "";
        }
        String string = GlobalDao.getNewMessage();
        String[] stringArray = string.split("\n");
        if (stringArray.length < 2) {
            return "";
        }
        int n2 = nxd.lib.c.d(stringArray[0].trim());
        String string2 = stringArray[1].trim();
        try (b b2 = DaoUtil.getDbConfig();){
            int n3 = b2.f("select msg_idx from config");
            if (n2 <= n3) {
                String string3 = "";
                return string3;
            }
            String string4 = "update config set msg_idx = " + n2;
            b2.b(string4);
            return string2;
        }
        catch (Exception exception) {
            this.d.error("AdminLoginDao.getNewMessage, DB error! - " + exception.toString());
        }
        return string2;
    }
}

