/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import nxd.dao.ClusterDao;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.AdminData;
import nxd.lib.RowSet;
import nxd.lib.b;
import org.apache.commons.codec.digest.DigestUtils;

public class AdminDao
extends FirstDao {
    public AdminData selectOne() {
        AdminData adminData = new AdminData();
        String string = "select * from admin";
        boolean bl = new ClusterDao().isSlave();
        if (bl) {
            try (b b2 = DaoUtil.getDbLocal();
                 RowSet rowSet = b2.m(string);){
                adminData.name = rowSet.getString("name");
                adminData.adminPw = rowSet.getString("admin_pw");
            }
            catch (Exception exception) {
                this.d.error("AdminDao.selectOne, " + exception.toString());
            }
        } else {
            try (b b3 = DaoUtil.getDbConfig();
                 RowSet rowSet = b3.m(string);){
                adminData.name = rowSet.getString("name");
                adminData.adminPw = rowSet.getString("admin_pw");
                adminData.magicPw = rowSet.getString("magic_pw");
            }
            catch (Exception exception) {
                this.d.error("AdminDao.selectOne, " + exception.toString());
            }
        }
        return adminData;
    }

    private boolean a(AdminData adminData) {
        if (!ParamTest.isValidNameLen(adminData.name)) {
            this.d.error("ADcP {}", (Object)ParamTest.ERR_NAME_LEN);
            return false;
        }
        if (!ParamTest.isValidNameChar(adminData.name)) {
            this.d.error("ADcP {}", (Object)"Only alphabet, number, [-_] allowed in name.");
            return false;
        }
        if (ParamTest.isDupOperator(adminData.name)) {
            this.d.error("ADcP, Admin name can't be same as opertor!");
            return false;
        }
        return true;
    }

    public boolean update(AdminData adminData) {
        adminData.sanitize();
        if (!this.a(adminData)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "update admin set name = ?";
        boolean bl = b2.d(string, new Object[]{adminData.name});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("admin");
        return true;
    }

    public boolean updateAdminPw(String string) {
        if (!ParamTest.isValidPasswdLen(string)) {
            this.d.error("ADuP {}", (Object)ParamTest.ERR_PASSWD_LEN);
            return false;
        }
        if (!ParamTest.isValidPasswdChar(string)) {
            this.d.error("ADuP {}", (Object)"Only ASCII character allowed in password.");
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string2 = "update admin set admin_pw = ?";
        boolean bl = b2.d(string2, new Object[]{DigestUtils.shaHex(string)});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("admin");
        return true;
    }

    public boolean isAdminPw(String string) {
        AdminData adminData = this.selectOne();
        return DigestUtils.shaHex(string).equals(adminData.adminPw);
    }

    public boolean updateMagicPw(String string) {
        if (!ParamTest.isValidPasswdLen(string)) {
            this.d.error("ADuPw {}", (Object)ParamTest.ERR_PASSWD_LEN);
            return false;
        }
        if (!ParamTest.isValidPasswdChar(string)) {
            this.d.error("ADuPw {}", (Object)"Only ASCII character allowed in password.");
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string2 = "update admin set magic_pw = ?";
        boolean bl = b2.d(string2, new Object[]{DigestUtils.shaHex(string)});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        return true;
    }

    public boolean isMagicPw(String string) {
        AdminData adminData = this.selectOne();
        return DigestUtils.shaHex(string).equals(adminData.magicPw);
    }
}

