/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server.impl;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.productivity.java.syslog4j.SyslogCharSetIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.SyslogServerConfigIF;
import org.productivity.java.syslog4j.server.SyslogServerEventHandlerIF;
import org.productivity.java.syslog4j.server.SyslogServerEventIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;
import org.productivity.java.syslog4j.server.SyslogServerSessionEventHandlerIF;
import org.productivity.java.syslog4j.server.SyslogServerSessionlessEventHandlerIF;
import org.productivity.java.syslog4j.server.impl.AbstractSyslogServerConfig;
import org.productivity.java.syslog4j.server.impl.event.SyslogServerEvent;
import org.productivity.java.syslog4j.server.impl.event.structured.StructuredSyslogServerEvent;
import org.productivity.java.syslog4j.util.SyslogUtility;

public abstract class AbstractSyslogServer
implements SyslogServerIF {
    protected String syslogProtocol = null;
    protected AbstractSyslogServerConfig syslogServerConfig = null;
    protected Thread thread = null;
    protected boolean shutdown = false;

    public void initialize(String string, SyslogServerConfigIF syslogServerConfigIF) throws SyslogRuntimeException {
        this.syslogProtocol = string;
        try {
            this.syslogServerConfig = (AbstractSyslogServerConfig)syslogServerConfigIF;
        }
        catch (ClassCastException classCastException) {
            throw new SyslogRuntimeException(classCastException);
        }
        this.initialize();
    }

    public String getProtocol() {
        return this.syslogProtocol;
    }

    public SyslogServerConfigIF getConfig() {
        return this.syslogServerConfig;
    }

    protected abstract void initialize() throws SyslogRuntimeException;

    public void shutdown() throws SyslogRuntimeException {
        this.shutdown = true;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    protected static boolean isStructuredMessage(SyslogCharSetIF syslogCharSetIF, byte[] byArray) {
        String string = SyslogUtility.newString(syslogCharSetIF, byArray);
        boolean bl = AbstractSyslogServer.isStructuredMessage(syslogCharSetIF, string);
        return bl;
    }

    protected static boolean isStructuredMessage(SyslogCharSetIF syslogCharSetIF, String string) {
        int n = string.indexOf(62);
        return n != -1 && string.length() > n + 1 && Character.isDigit(string.charAt(n + 1));
    }

    protected static SyslogServerEventIF createEvent(SyslogServerConfigIF syslogServerConfigIF, byte[] byArray, int n, InetAddress inetAddress) {
        SyslogServerEvent syslogServerEvent = null;
        if (syslogServerConfigIF.isUseStructuredData() && AbstractSyslogServer.isStructuredMessage((SyslogCharSetIF)syslogServerConfigIF, byArray)) {
            syslogServerEvent = new StructuredSyslogServerEvent(byArray, n, inetAddress);
            if (syslogServerConfigIF.getDateTimeFormatter() != null) {
                ((StructuredSyslogServerEvent)syslogServerEvent).setDateTimeFormatter(syslogServerConfigIF.getDateTimeFormatter());
            }
        } else {
            syslogServerEvent = new SyslogServerEvent(byArray, n, inetAddress);
        }
        return syslogServerEvent;
    }

    protected static SyslogServerEventIF createEvent(SyslogServerConfigIF syslogServerConfigIF, String string, InetAddress inetAddress) {
        SyslogServerEvent syslogServerEvent = null;
        syslogServerEvent = syslogServerConfigIF.isUseStructuredData() && AbstractSyslogServer.isStructuredMessage((SyslogCharSetIF)syslogServerConfigIF, string) ? new StructuredSyslogServerEvent(string, inetAddress) : new SyslogServerEvent(string, inetAddress);
        return syslogServerEvent;
    }

    public static void handleInitialize(SyslogServerIF syslogServerIF) {
        List list = syslogServerIF.getConfig().getEventHandlers();
        for (int i = 0; i < list.size(); ++i) {
            SyslogServerEventHandlerIF syslogServerEventHandlerIF = (SyslogServerEventHandlerIF)list.get(i);
            try {
                syslogServerEventHandlerIF.initialize(syslogServerIF);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void handleDestroy(SyslogServerIF syslogServerIF) {
        List list = syslogServerIF.getConfig().getEventHandlers();
        for (int i = 0; i < list.size(); ++i) {
            SyslogServerEventHandlerIF syslogServerEventHandlerIF = (SyslogServerEventHandlerIF)list.get(i);
            try {
                syslogServerEventHandlerIF.destroy(syslogServerIF);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void handleSessionOpen(Sessions sessions, SyslogServerIF syslogServerIF, Socket socket) {
        List list = syslogServerIF.getConfig().getEventHandlers();
        for (int i = 0; i < list.size(); ++i) {
            SyslogServerEventHandlerIF syslogServerEventHandlerIF = (SyslogServerEventHandlerIF)list.get(i);
            if (!(syslogServerEventHandlerIF instanceof SyslogServerSessionEventHandlerIF)) continue;
            try {
                Object object = ((SyslogServerSessionEventHandlerIF)syslogServerEventHandlerIF).sessionOpened(syslogServerIF, socket.getRemoteSocketAddress());
                if (object == null) continue;
                sessions.addSession(socket, syslogServerEventHandlerIF, object);
                continue;
            }
            catch (Exception exception) {
                try {
                    ((SyslogServerSessionEventHandlerIF)syslogServerEventHandlerIF).exception(null, syslogServerIF, socket.getRemoteSocketAddress(), exception);
                    continue;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    public static void handleSessionClosed(Sessions sessions, SyslogServerIF syslogServerIF, Socket socket, boolean bl) {
        List list = syslogServerIF.getConfig().getEventHandlers();
        for (int i = 0; i < list.size(); ++i) {
            SyslogServerEventHandlerIF syslogServerEventHandlerIF = (SyslogServerEventHandlerIF)list.get(i);
            if (!(syslogServerEventHandlerIF instanceof SyslogServerSessionEventHandlerIF)) continue;
            Object object = sessions.getSession(socket, syslogServerEventHandlerIF);
            try {
                ((SyslogServerSessionEventHandlerIF)syslogServerEventHandlerIF).sessionClosed(object, syslogServerIF, socket.getRemoteSocketAddress(), bl);
                continue;
            }
            catch (Exception exception) {
                try {
                    ((SyslogServerSessionEventHandlerIF)syslogServerEventHandlerIF).exception(object, syslogServerIF, socket.getRemoteSocketAddress(), exception);
                    continue;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    public static void handleEvent(Sessions sessions, SyslogServerIF syslogServerIF, DatagramPacket datagramPacket, SyslogServerEventIF syslogServerEventIF) {
        AbstractSyslogServer.handleEvent(sessions, syslogServerIF, null, datagramPacket.getSocketAddress(), syslogServerEventIF);
    }

    public static void handleEvent(Sessions sessions, SyslogServerIF syslogServerIF, Socket socket, SyslogServerEventIF syslogServerEventIF) {
        AbstractSyslogServer.handleEvent(sessions, syslogServerIF, socket, socket.getRemoteSocketAddress(), syslogServerEventIF);
    }

    protected static void handleEvent(Sessions sessions, SyslogServerIF syslogServerIF, Socket socket, SocketAddress socketAddress, SyslogServerEventIF syslogServerEventIF) {
        List list = syslogServerIF.getConfig().getEventHandlers();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            SyslogServerEventHandlerIF syslogServerEventHandlerIF = (SyslogServerEventHandlerIF)list.get(i);
            Object object2 = object = sessions != null && socket != null ? sessions.getSession(socket, syslogServerEventHandlerIF) : null;
            if (syslogServerEventHandlerIF instanceof SyslogServerSessionEventHandlerIF) {
                try {
                    ((SyslogServerSessionEventHandlerIF)syslogServerEventHandlerIF).event(object, syslogServerIF, socketAddress, syslogServerEventIF);
                }
                catch (Exception exception) {
                    try {
                        ((SyslogServerSessionEventHandlerIF)syslogServerEventHandlerIF).exception(object, syslogServerIF, socketAddress, exception);
                    }
                    catch (Exception exception2) {}
                }
                continue;
            }
            if (!(syslogServerEventHandlerIF instanceof SyslogServerSessionlessEventHandlerIF)) continue;
            try {
                ((SyslogServerSessionlessEventHandlerIF)syslogServerEventHandlerIF).event(syslogServerIF, socketAddress, syslogServerEventIF);
                continue;
            }
            catch (Exception exception) {
                try {
                    ((SyslogServerSessionlessEventHandlerIF)syslogServerEventHandlerIF).exception(syslogServerIF, socketAddress, exception);
                    continue;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
        }
    }

    public static void handleException(Object object, SyslogServerIF syslogServerIF, SocketAddress socketAddress, Exception exception) {
        List list = syslogServerIF.getConfig().getEventHandlers();
        for (int i = 0; i < list.size(); ++i) {
            SyslogServerEventHandlerIF syslogServerEventHandlerIF = (SyslogServerEventHandlerIF)list.get(i);
            if (syslogServerEventHandlerIF instanceof SyslogServerSessionEventHandlerIF) {
                try {
                    ((SyslogServerSessionEventHandlerIF)syslogServerEventHandlerIF).exception(object, syslogServerIF, socketAddress, exception);
                }
                catch (Exception exception2) {}
                continue;
            }
            if (!(syslogServerEventHandlerIF instanceof SyslogServerSessionlessEventHandlerIF)) continue;
            try {
                ((SyslogServerSessionlessEventHandlerIF)syslogServerEventHandlerIF).exception(syslogServerIF, socketAddress, exception);
                continue;
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
    }

    public static class Sessions
    extends HashMap {
        private static final long serialVersionUID = -4438949276263772580L;
        public static final Object syncObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSocket(Socket socket) {
            Object object = syncObject;
            synchronized (object) {
                this.put(socket, new HashMap());
            }
        }

        public Iterator getSockets() {
            if (this.size() > 0) {
                return this.keySet().iterator();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSession(Socket socket, SyslogServerEventHandlerIF syslogServerEventHandlerIF, Object object) {
            Object object2 = syncObject;
            synchronized (object2) {
                HashMap<SyslogServerEventHandlerIF, Object> hashMap = this.getHandlerMap(socket);
                if (hashMap == null) {
                    hashMap = new HashMap<SyslogServerEventHandlerIF, Object>();
                }
                hashMap.put(syslogServerEventHandlerIF, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSocket(Socket socket) {
            Object object = syncObject;
            synchronized (object) {
                Map map = this.getHandlerMap(socket);
                if (map != null) {
                    map.clear();
                }
            }
        }

        protected Map getHandlerMap(Socket socket) {
            Map map = null;
            if (this.containsKey(socket)) {
                map = (Map)this.get(socket);
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getSession(Socket socket, SyslogServerEventHandlerIF syslogServerEventHandlerIF) {
            Object object = syncObject;
            synchronized (object) {
                Map map = this.getHandlerMap(socket);
                Object v = map.get(syslogServerEventHandlerIF);
                return v;
            }
        }
    }
}

