/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.unix;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import org.productivity.java.syslog4j.SyslogMessageProcessorIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.AbstractSyslog;
import org.productivity.java.syslog4j.impl.AbstractSyslogWriter;
import org.productivity.java.syslog4j.impl.unix.UnixSyslogConfig;
import org.productivity.java.syslog4j.util.OSDetectUtility;

public class UnixSyslog
extends AbstractSyslog {
    private static final long serialVersionUID = 4973353204252276740L;
    protected UnixSyslogConfig unixSyslogConfig = null;
    protected static int currentFacility = -1;
    protected static boolean openlogCalled = false;
    protected static CLibrary libraryInstance = null;
    static /* synthetic */ Class class$org$productivity$java$syslog4j$impl$unix$UnixSyslog$CLibrary;

    protected static synchronized void loadLibrary(UnixSyslogConfig unixSyslogConfig) throws SyslogRuntimeException {
        if (!OSDetectUtility.isUnix()) {
            throw new SyslogRuntimeException("UnixSyslog not supported on non-Unix platforms");
        }
        if (libraryInstance == null) {
            libraryInstance = (CLibrary)Native.loadLibrary((String)unixSyslogConfig.getLibrary(), (Class)(class$org$productivity$java$syslog4j$impl$unix$UnixSyslog$CLibrary == null ? (class$org$productivity$java$syslog4j$impl$unix$UnixSyslog$CLibrary = UnixSyslog.class$("org.productivity.java.syslog4j.impl.unix.UnixSyslog$CLibrary")) : class$org$productivity$java$syslog4j$impl$unix$UnixSyslog$CLibrary));
        }
    }

    public void initialize() throws SyslogRuntimeException {
        try {
            this.unixSyslogConfig = (UnixSyslogConfig)this.syslogConfig;
        }
        catch (ClassCastException classCastException) {
            throw new SyslogRuntimeException("config must be of type UnixSyslogConfig");
        }
        UnixSyslog.loadLibrary(this.unixSyslogConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void write(int n, String string, UnixSyslogConfig unixSyslogConfig) throws SyslogRuntimeException {
        CLibrary cLibrary = libraryInstance;
        synchronized (cLibrary) {
            if (currentFacility != unixSyslogConfig.getFacility()) {
                if (openlogCalled) {
                    libraryInstance.closelog();
                    openlogCalled = false;
                }
                currentFacility = unixSyslogConfig.getFacility();
            }
            if (!openlogCalled) {
                String string2 = unixSyslogConfig.getIdent();
                if (string2 != null && "".equals(string2.trim())) {
                    string2 = null;
                }
                Memory memory = null;
                if (string2 != null) {
                    memory = new Memory(128L);
                    memory.setString(0L, string2, false);
                }
                libraryInstance.openlog(memory, unixSyslogConfig.getOption(), currentFacility);
                openlogCalled = true;
            }
            int n2 = currentFacility | n;
            libraryInstance.syslog(n2, "%s", string);
        }
    }

    protected void write(int n, byte[] byArray) throws SyslogRuntimeException {
    }

    public void log(SyslogMessageProcessorIF syslogMessageProcessorIF, int n, String string) {
        UnixSyslog.write(n, string, this.unixSyslogConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws SyslogRuntimeException {
        CLibrary cLibrary = libraryInstance;
        synchronized (cLibrary) {
            libraryInstance.closelog();
            openlogCalled = false;
        }
    }

    public void shutdown() throws SyslogRuntimeException {
        this.flush();
    }

    public AbstractSyslogWriter getWriter() {
        return null;
    }

    public void returnWriter(AbstractSyslogWriter abstractSyslogWriter) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static interface CLibrary
    extends Library {
        public void openlog(Memory var1, int var2, int var3);

        public void syslog(int var1, String var2, String var3);

        public void closelog();
    }
}

