/*
 * Decompiled with CFR 0.152.
 */
package nettrack.util;

public class ByteUtil {
    public static final int getUByte(byte[] data, int offset) {
        return data[offset] & 0xFF;
    }

    public static final int getUShort(byte[] data, int offset) {
        int b0 = ByteUtil.getUByte(data, offset + 0);
        int b1 = ByteUtil.getUByte(data, offset + 1);
        return (b0 << 8) + b1;
    }

    public static final long getULong(byte[] data, int offset) {
        long b0 = ByteUtil.getUByte(data, offset + 0);
        long b1 = ByteUtil.getUByte(data, offset + 1);
        long b2 = ByteUtil.getUByte(data, offset + 2);
        long b3 = ByteUtil.getUByte(data, offset + 3);
        return (((b0 << 8) + b1 << 8) + b2 << 8) + b3;
    }

    public static final void setUByte(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
    }

    public static final void setUShort(byte[] data, int offset, int value) {
        data[offset + 1] = (byte)(value & 0xFF);
        data[offset] = (byte)((value >>= 8) & 0xFF);
    }

    public static final void setULong(byte[] data, int offset, long value) {
        data[offset + 3] = (byte)(value & 0xFFL);
        data[offset + 2] = (byte)((value >>= 8) & 0xFFL);
        data[offset + 1] = (byte)((value >>= 8) & 0xFFL);
        data[offset] = (byte)((value >>= 8) & 0xFFL);
    }
}

